<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_consume" table
 */
#[Entity]
#[Table(name: "stock_consume")]
class StockConsume extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(type: "integer", nullable: true)]
    private ?int $barcode;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(name: "l_cm", type: "smallint", nullable: true)]
    private ?int $lCm;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "consumed_by", type: "string", nullable: true)]
    private ?string $consumedBy;

    #[Column(name: "consumed_status", type: "integer")]
    private int $consumedStatus;

    #[Column(name: "consumed_sqm", type: "decimal", nullable: true)]
    private ?string $consumedSqm;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->location = (isset($_COOKIE["Location"]))? $_COOKIE["Location"]:User_Site();
        $this->barcode = (isset($_GET["b"]))? $_GET["b"]:"";
        $this->designId = (isset($_GET["d"]))? $_GET["d"]:"";
        $this->wCm = (isset($_GET["w"]))? $_GET["w"]:"";
        $this->lCm = (isset($_GET["l"]))? $_GET["l"]:"";
        $this->sqm = (isset($_GET["sq"]))? $_GET["sq"]:"";
        $this->status = (isset($_GET["s"]))? $_GET["s"]:"";
        $this->consumedStatus = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getBarcode(): ?int
    {
        return $this->barcode;
    }

    public function setBarcode(?int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getConsumedBy(): ?string
    {
        return HtmlDecode($this->consumedBy);
    }

    public function setConsumedBy(?string $value): static
    {
        $this->consumedBy = RemoveXss($value);
        return $this;
    }

    public function getConsumedStatus(): int
    {
        return $this->consumedStatus;
    }

    public function setConsumedStatus(int $value): static
    {
        $this->consumedStatus = $value;
        return $this;
    }

    public function getConsumedSqm(): ?string
    {
        return $this->consumedSqm;
    }

    public function setConsumedSqm(?string $value): static
    {
        $this->consumedSqm = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
