<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_barcode" table
 */
#[Entity]
#[Table(name: "stock_barcode")]
class StockBarcode extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "string", nullable: true)]
    private ?string $rid;

    #[Column(type: "smallint")]
    private int $godown;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal")]
    private string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "decimal")]
    private string $out;

    #[Column(name: "Balance", type: "decimal")]
    private string $balance;

    #[Column(type: "integer")]
    private int $packets;

    #[Column(name: "packing_type", type: "integer")]
    private int $packingType;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(type: "string")]
    private string $dated;

    #[Column(type: "string")]
    private string $type;

    #[Column(type: "string")]
    private string $url;

    #[Column(type: "integer")]
    private int $age;

    #[Column(name: "`@`", options: ["name" => "@"], type: "integer")]
    private int $40;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    public function __construct()
    {
        $this->packingType = 0;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(?string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getGodown(): int
    {
        return $this->godown;
    }

    public function setGodown(int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getIn(): string
    {
        return $this->in;
    }

    public function setIn(string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): string
    {
        return $this->out;
    }

    public function setOut(string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getBalance(): string
    {
        return $this->balance;
    }

    public function setBalance(string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getPackets(): int
    {
        return $this->packets;
    }

    public function setPackets(int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getDated(): string
    {
        return HtmlDecode($this->dated);
    }

    public function setDated(string $value): static
    {
        $this->dated = RemoveXss($value);
        return $this;
    }

    public function getType(): string
    {
        return HtmlDecode($this->type);
    }

    public function setType(string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getAge(): int
    {
        return $this->age;
    }

    public function setAge(int $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function get40(): int
    {
        return $this->40;
    }

    public function set40(int $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }
}
