<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock" table
 */
#[Entity]
#[Table(name: "stock")]
class Stock extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "packing_type", type: "decimal", nullable: true)]
    private ?string $packingType;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(type: "decimal", nullable: true)]
    private ?string $hold;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "avg_quantity", type: "decimal", nullable: true)]
    private ?string $avgQuantity;

    #[Column(type: "bigint", nullable: true)]
    private ?string $rid;

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?string
    {
        return $this->packingType;
    }

    public function setPackingType(?string $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getHold(): ?string
    {
        return $this->hold;
    }

    public function setHold(?string $value): static
    {
        $this->hold = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getAvgQuantity(): ?string
    {
        return $this->avgQuantity;
    }

    public function setAvgQuantity(?string $value): static
    {
        $this->avgQuantity = $value;
        return $this;
    }

    public function getRid(): ?string
    {
        return $this->rid;
    }

    public function setRid(?string $value): static
    {
        $this->rid = $value;
        return $this;
    }
}
