<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "static_pages" table
 */
#[Entity]
#[Table(name: "static_pages")]
class StaticPage extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    private int $id;

    #[Column(name: "menu_id", type: "smallint")]
    private int $menuId;

    #[Column(name: "meta_desc", type: "string")]
    private string $metaDesc;

    #[Column(name: "meta_keyword", type: "string")]
    private string $metaKeyword;

    #[Column(name: "page_desc", type: "text")]
    private string $pageDesc;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMenuId(): int
    {
        return $this->menuId;
    }

    public function setMenuId(int $value): static
    {
        $this->menuId = $value;
        return $this;
    }

    public function getMetaDesc(): string
    {
        return HtmlDecode($this->metaDesc);
    }

    public function setMetaDesc(string $value): static
    {
        $this->metaDesc = RemoveXss($value);
        return $this;
    }

    public function getMetaKeyword(): string
    {
        return HtmlDecode($this->metaKeyword);
    }

    public function setMetaKeyword(string $value): static
    {
        $this->metaKeyword = RemoveXss($value);
        return $this;
    }

    public function getPageDesc(): string
    {
        return HtmlDecode($this->pageDesc);
    }

    public function setPageDesc(string $value): static
    {
        $this->pageDesc = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
