<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "shipping_address" table
 */
#[Entity]
#[Table(name: "shipping_address")]
class ShippingAddress extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $type;

    #[Column(type: "integer", nullable: true)]
    private ?int $userid;

    #[Column(name: "formal_name", type: "string", nullable: true)]
    private ?string $formalName;

    #[Column(type: "integer", nullable: true)]
    private ?int $country;

    #[Column(type: "smallint", nullable: true)]
    private ?int $state;

    #[Column(type: "bigint", nullable: true)]
    private ?string $city;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(name: "city_name", type: "string", nullable: true)]
    private ?string $cityName;

    #[Column(type: "string", nullable: true)]
    private ?string $zipcode;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(name: "gst_number", type: "string", nullable: true)]
    private ?string $gstNumber;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "cart_number", type: "integer", nullable: true)]
    private ?int $cartNumber;

    #[Column(name: "r_text", type: "text", nullable: true)]
    private ?string $rText;

    public function __construct()
    {
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): ?int
    {
        return $this->type;
    }

    public function setType(?int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getUserid(): ?int
    {
        return $this->userid;
    }

    public function setUserid(?int $value): static
    {
        $this->userid = $value;
        return $this;
    }

    public function getFormalName(): ?string
    {
        return HtmlDecode($this->formalName);
    }

    public function setFormalName(?string $value): static
    {
        $this->formalName = RemoveXss($value);
        return $this;
    }

    public function getCountry(): ?int
    {
        return $this->country;
    }

    public function setCountry(?int $value): static
    {
        $this->country = $value;
        return $this;
    }

    public function getState(): ?int
    {
        return $this->state;
    }

    public function setState(?int $value): static
    {
        $this->state = $value;
        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $value): static
    {
        $this->city = $value;
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getCityName(): ?string
    {
        return HtmlDecode($this->cityName);
    }

    public function setCityName(?string $value): static
    {
        $this->cityName = RemoveXss($value);
        return $this;
    }

    public function getZipcode(): ?string
    {
        return HtmlDecode($this->zipcode);
    }

    public function setZipcode(?string $value): static
    {
        $this->zipcode = RemoveXss($value);
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getGstNumber(): ?string
    {
        return HtmlDecode($this->gstNumber);
    }

    public function setGstNumber(?string $value): static
    {
        $this->gstNumber = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getCartNumber(): ?int
    {
        return $this->cartNumber;
    }

    public function setCartNumber(?int $value): static
    {
        $this->cartNumber = $value;
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }
}
