<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "share_transfer" table
 */
#[Entity]
#[Table(name: "share_transfer")]
class ShareTransfer extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "folio_new", type: "smallint", nullable: true)]
    private ?int $folioNew;

    #[Column(name: "folio_old", type: "smallint", nullable: true)]
    private ?int $folioOld;

    #[Column(type: "smallint", nullable: true)]
    private ?int $adviser;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(name: "transfer_date", type: "date", nullable: true)]
    private ?DateTime $transferDate;

    #[Column(name: "share_no_start", type: "integer", nullable: true)]
    private ?int $shareNoStart;

    #[Column(name: "share_no_end", type: "integer", nullable: true)]
    private ?int $shareNoEnd;

    #[Column(type: "string", nullable: true)]
    private ?string $pan;

    #[Column(type: "string", nullable: true)]
    private ?string $aadhaar;

    #[Column(name: "duty_folio_new", type: "decimal")]
    private string $dutyFolioNew;

    #[Column(name: "duty_company", type: "decimal")]
    private string $dutyCompany;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $updated;

    public function __construct()
    {
        $this->folioNew = (isset($_GET["FN"]))? $_GET["FN"]:'';
        $this->dutyFolioNew = "0.00";
        $this->dutyCompany = "0.00";
        $this->operator = 0;
        $this->updated = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getFolioNew(): ?int
    {
        return $this->folioNew;
    }

    public function setFolioNew(?int $value): static
    {
        $this->folioNew = $value;
        return $this;
    }

    public function getFolioOld(): ?int
    {
        return $this->folioOld;
    }

    public function setFolioOld(?int $value): static
    {
        $this->folioOld = $value;
        return $this;
    }

    public function getAdviser(): ?int
    {
        return $this->adviser;
    }

    public function setAdviser(?int $value): static
    {
        $this->adviser = $value;
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getTransferDate(): ?DateTime
    {
        return $this->transferDate;
    }

    public function setTransferDate(?DateTime $value): static
    {
        $this->transferDate = $value;
        return $this;
    }

    public function getShareNoStart(): ?int
    {
        return $this->shareNoStart;
    }

    public function setShareNoStart(?int $value): static
    {
        $this->shareNoStart = $value;
        return $this;
    }

    public function getShareNoEnd(): ?int
    {
        return $this->shareNoEnd;
    }

    public function setShareNoEnd(?int $value): static
    {
        $this->shareNoEnd = $value;
        return $this;
    }

    public function getPan(): ?string
    {
        return HtmlDecode($this->pan);
    }

    public function setPan(?string $value): static
    {
        $this->pan = RemoveXss($value);
        return $this;
    }

    public function getAadhaar(): ?string
    {
        return HtmlDecode($this->aadhaar);
    }

    public function setAadhaar(?string $value): static
    {
        $this->aadhaar = RemoveXss($value);
        return $this;
    }

    public function getDutyFolioNew(): string
    {
        return $this->dutyFolioNew;
    }

    public function setDutyFolioNew(string $value): static
    {
        $this->dutyFolioNew = $value;
        return $this;
    }

    public function getDutyCompany(): string
    {
        return $this->dutyCompany;
    }

    public function setDutyCompany(string $value): static
    {
        $this->dutyCompany = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUpdated(): ?int
    {
        return $this->updated;
    }

    public function setUpdated(?int $value): static
    {
        $this->updated = $value;
        return $this;
    }
}
