<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "service_schedule" table
 */
#[Entity]
#[Table(name: "service_schedule")]
class ServiceSchedule extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "buyer_id", type: "smallint", nullable: true)]
    private ?int $buyerId;

    #[Column(name: "hardware_id", type: "smallint")]
    private int $hardwareId;

    #[Column(name: "service_type", type: "smallint", nullable: true)]
    private ?int $serviceType;

    #[Column(name: "service_duedate", type: "date", nullable: true)]
    private ?DateTime $serviceDuedate;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "service_executive", type: "smallint", nullable: true)]
    private ?int $serviceExecutive;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->buyerId = (isset($_COOKIE["CID"]))? $_COOKIE["CID"]:'';
        $this->hardwareId = (isset($_COOKIE["HI"]))? $_COOKIE["HI"]:'';
        $this->serviceType = (isset($_COOKIE["ST"]))? $_COOKIE["ST"]:'';
        $this->serviceExecutive = (isset($_COOKIE["SE"]))? $_COOKIE["SE"]:'';
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyerId(): ?int
    {
        return $this->buyerId;
    }

    public function setBuyerId(?int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getHardwareId(): int
    {
        return $this->hardwareId;
    }

    public function setHardwareId(int $value): static
    {
        $this->hardwareId = $value;
        return $this;
    }

    public function getServiceType(): ?int
    {
        return $this->serviceType;
    }

    public function setServiceType(?int $value): static
    {
        $this->serviceType = $value;
        return $this;
    }

    public function getServiceDuedate(): ?DateTime
    {
        return $this->serviceDuedate;
    }

    public function setServiceDuedate(?DateTime $value): static
    {
        $this->serviceDuedate = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getServiceExecutive(): ?int
    {
        return $this->serviceExecutive;
    }

    public function setServiceExecutive(?int $value): static
    {
        $this->serviceExecutive = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
