<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "service_request" table
 */
#[Entity]
#[Table(name: "service_request")]
class ServiceRequest extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $status;

    #[Column(name: "buyer_id", type: "integer")]
    private int $buyerId;

    #[Column(name: "product_ref", type: "smallint", nullable: true)]
    private ?int $productRef;

    #[Column(name: "current_reading", type: "integer")]
    private int $currentReading;

    #[Column(name: "product_status", type: "smallint", nullable: true)]
    private ?int $productStatus;

    #[Column(type: "string", nullable: true)]
    private ?string $error;

    #[Column(name: "last_serve", type: "datetime", nullable: true)]
    private ?DateTime $lastServe;

    #[Column(name: "last_serve_by", type: "smallint", nullable: true)]
    private ?int $lastServeBy;

    #[Column(name: "query_by", type: "string", nullable: true)]
    private ?string $queryBy;

    #[Column(name: "service_executive", type: "smallint")]
    private int $serviceExecutive;

    #[Column(name: "Ins_service_executive", type: "string")]
    private string $insServiceExecutive;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "o_operator", type: "smallint")]
    private int $oOperator;

    #[Column(name: "o_datetime", type: "datetime")]
    private DateTime $oDatetime;

    #[Column(name: "rid_1", type: "string")]
    private string $rid1;

    #[Column(name: "master_reading", type: "integer")]
    private int $masterReading;

    public function __construct()
    {
        $this->status = 0;
        $this->buyerId = isset($_GET['b']) ? $_GET['b'] : '';
        $this->operator = 0;
        $this->rid1 = "--NA--";
        $this->masterReading = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getBuyerId(): int
    {
        return $this->buyerId;
    }

    public function setBuyerId(int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getProductRef(): ?int
    {
        return $this->productRef;
    }

    public function setProductRef(?int $value): static
    {
        $this->productRef = $value;
        return $this;
    }

    public function getCurrentReading(): int
    {
        return $this->currentReading;
    }

    public function setCurrentReading(int $value): static
    {
        $this->currentReading = $value;
        return $this;
    }

    public function getProductStatus(): ?int
    {
        return $this->productStatus;
    }

    public function setProductStatus(?int $value): static
    {
        $this->productStatus = $value;
        return $this;
    }

    public function getError(): ?string
    {
        return HtmlDecode($this->error);
    }

    public function setError(?string $value): static
    {
        $this->error = RemoveXss($value);
        return $this;
    }

    public function getLastServe(): ?DateTime
    {
        return $this->lastServe;
    }

    public function setLastServe(?DateTime $value): static
    {
        $this->lastServe = $value;
        return $this;
    }

    public function getLastServeBy(): ?int
    {
        return $this->lastServeBy;
    }

    public function setLastServeBy(?int $value): static
    {
        $this->lastServeBy = $value;
        return $this;
    }

    public function getQueryBy(): ?string
    {
        return HtmlDecode($this->queryBy);
    }

    public function setQueryBy(?string $value): static
    {
        $this->queryBy = RemoveXss($value);
        return $this;
    }

    public function getServiceExecutive(): int
    {
        return $this->serviceExecutive;
    }

    public function setServiceExecutive(int $value): static
    {
        $this->serviceExecutive = $value;
        return $this;
    }

    public function getInsServiceExecutive(): string
    {
        return HtmlDecode($this->insServiceExecutive);
    }

    public function setInsServiceExecutive(string $value): static
    {
        $this->insServiceExecutive = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getOOperator(): int
    {
        return $this->oOperator;
    }

    public function setOOperator(int $value): static
    {
        $this->oOperator = $value;
        return $this;
    }

    public function getODatetime(): DateTime
    {
        return $this->oDatetime;
    }

    public function setODatetime(DateTime $value): static
    {
        $this->oDatetime = $value;
        return $this;
    }

    public function getRid1(): string
    {
        return HtmlDecode($this->rid1);
    }

    public function setRid1(string $value): static
    {
        $this->rid1 = RemoveXss($value);
        return $this;
    }

    public function getMasterReading(): int
    {
        return $this->masterReading;
    }

    public function setMasterReading(int $value): static
    {
        $this->masterReading = $value;
        return $this;
    }
}
