<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "service_report" table
 */
#[Entity]
#[Table(name: "service_report")]
class ServiceReport extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "buyer_id", type: "integer")]
    private int $buyerId;

    #[Column(name: "hardware_id", type: "smallint", nullable: true)]
    private ?int $hardwareId;

    #[Column(name: "service_executive", type: "smallint", nullable: true)]
    private ?int $serviceExecutive;

    #[Column(name: "entry_time", type: "datetime", nullable: true)]
    private ?DateTime $entryTime;

    #[Column(name: "current_reading", type: "integer")]
    private int $currentReading;

    #[Column(name: "error_ref", type: "string", nullable: true)]
    private ?string $errorRef;

    #[Column(name: "service_type", type: "smallint", nullable: true)]
    private ?int $serviceType;

    #[Column(type: "string", nullable: true)]
    private ?string $complaint;

    #[Column(type: "string", nullable: true)]
    private ?string $observation;

    #[Column(name: "product_replaced", type: "string", nullable: true)]
    private ?string $productReplaced;

    #[Column(name: "consumable_replaced", type: "string", nullable: true)]
    private ?string $consumableReplaced;

    #[Column(name: "work_detail", type: "string", nullable: true)]
    private ?string $workDetail;

    #[Column(name: "future_task", type: "string", nullable: true)]
    private ?string $futureTask;

    #[Column(name: "last_status", type: "smallint", nullable: true)]
    private ?int $lastStatus;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(name: "out_time", type: "datetime", nullable: true)]
    private ?DateTime $outTime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(type: "string", nullable: true)]
    private ?string $invoice;

    #[Column(name: "invoice_date", type: "datetime", nullable: true)]
    private ?DateTime $invoiceDate;

    public function __construct()
    {
        $this->buyerId = (isset($_COOKIE["CID"]))? $_COOKIE["CID"]:'';
        $this->hardwareId = (isset($_COOKIE["HI"]))? $_COOKIE["HI"]:'';
        $this->serviceExecutive = (isset($_COOKIE["SE"]))? $_COOKIE["SE"]:'';
        $this->currentReading = (isset($_COOKIE["CR"]))? $_COOKIE["CR"]:'';
        $this->errorRef = (isset($_COOKIE["ER"]))? $_COOKIE["ER"]:'';
        $this->serviceType = (isset($_COOKIE["ST"]))? $_COOKIE["ST"]:'';
        $this->complaint = (isset($_COOKIE["CO"]))? $_COOKIE["CO"]:'';
        $this->observation = (isset($_COOKIE["OB"]))? $_COOKIE["OB"]:'';
        $this->productReplaced = (isset($_COOKIE["PRE"]))? $_COOKIE["PRE"]:'';
        $this->consumableReplaced = (isset($_COOKIE["CRE"]))? $_COOKIE["CRE"]:'';
        $this->workDetail = (isset($_COOKIE["WD"]))? $_COOKIE["WD"]:'';
        $this->futureTask = (isset($_COOKIE["FT"]))? $_COOKIE["FT"]:'';
        $this->lastStatus = 4104;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyerId(): int
    {
        return $this->buyerId;
    }

    public function setBuyerId(int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getHardwareId(): ?int
    {
        return $this->hardwareId;
    }

    public function setHardwareId(?int $value): static
    {
        $this->hardwareId = $value;
        return $this;
    }

    public function getServiceExecutive(): ?int
    {
        return $this->serviceExecutive;
    }

    public function setServiceExecutive(?int $value): static
    {
        $this->serviceExecutive = $value;
        return $this;
    }

    public function getEntryTime(): ?DateTime
    {
        return $this->entryTime;
    }

    public function setEntryTime(?DateTime $value): static
    {
        $this->entryTime = $value;
        return $this;
    }

    public function getCurrentReading(): int
    {
        return $this->currentReading;
    }

    public function setCurrentReading(int $value): static
    {
        $this->currentReading = $value;
        return $this;
    }

    public function getErrorRef(): ?string
    {
        return HtmlDecode($this->errorRef);
    }

    public function setErrorRef(?string $value): static
    {
        $this->errorRef = RemoveXss($value);
        return $this;
    }

    public function getServiceType(): ?int
    {
        return $this->serviceType;
    }

    public function setServiceType(?int $value): static
    {
        $this->serviceType = $value;
        return $this;
    }

    public function getComplaint(): ?string
    {
        return HtmlDecode($this->complaint);
    }

    public function setComplaint(?string $value): static
    {
        $this->complaint = RemoveXss($value);
        return $this;
    }

    public function getObservation(): ?string
    {
        return HtmlDecode($this->observation);
    }

    public function setObservation(?string $value): static
    {
        $this->observation = RemoveXss($value);
        return $this;
    }

    public function getProductReplaced(): ?string
    {
        return HtmlDecode($this->productReplaced);
    }

    public function setProductReplaced(?string $value): static
    {
        $this->productReplaced = RemoveXss($value);
        return $this;
    }

    public function getConsumableReplaced(): ?string
    {
        return HtmlDecode($this->consumableReplaced);
    }

    public function setConsumableReplaced(?string $value): static
    {
        $this->consumableReplaced = RemoveXss($value);
        return $this;
    }

    public function getWorkDetail(): ?string
    {
        return HtmlDecode($this->workDetail);
    }

    public function setWorkDetail(?string $value): static
    {
        $this->workDetail = RemoveXss($value);
        return $this;
    }

    public function getFutureTask(): ?string
    {
        return HtmlDecode($this->futureTask);
    }

    public function setFutureTask(?string $value): static
    {
        $this->futureTask = RemoveXss($value);
        return $this;
    }

    public function getLastStatus(): ?int
    {
        return $this->lastStatus;
    }

    public function setLastStatus(?int $value): static
    {
        $this->lastStatus = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOutTime(): ?DateTime
    {
        return $this->outTime;
    }

    public function setOutTime(?DateTime $value): static
    {
        $this->outTime = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getInvoice(): ?string
    {
        return HtmlDecode($this->invoice);
    }

    public function setInvoice(?string $value): static
    {
        $this->invoice = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDate(): ?DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?DateTime $value): static
    {
        $this->invoiceDate = $value;
        return $this;
    }
}
