<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "sample_req_cart_dispatch" table
 */
#[Entity]
#[Table(name: "sample_req_cart_dispatch")]
class SampleReqCartDispatch extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "old_ref", type: "string", nullable: true)]
    private ?string $oldRef;

    #[Column(type: "string")]
    private string $design;

    #[Column(type: "string")]
    private string $color;

    #[Column(type: "string")]
    private string $size;

    #[Column(type: "smallint")]
    private int $quantity;

    #[Column(name: "delivery_week", type: "smallint", nullable: true)]
    private ?int $deliveryWeek;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $upload;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "sp_remarks", type: "string", nullable: true)]
    private ?string $spRemarks;

    #[Column(name: "pp_remarks", type: "string", nullable: true)]
    private ?string $ppRemarks;

    #[Column(name: "po_remarks", type: "string", nullable: true)]
    private ?string $poRemarks;

    #[Column(type: "string", nullable: true)]
    private ?string $price;

    #[Column(type: "string", nullable: true)]
    private ?string $declaration;

    #[Column(type: "string", nullable: true)]
    private ?string $dispatch;

    #[Column(type: "string")]
    private string $bom;

    #[Column(name: "d_upload", type: "string", nullable: true)]
    private ?string $dUpload;

    #[Column(name: "da_comments", type: "string", nullable: true)]
    private ?string $daComments;

    #[Column(name: "da_status", type: "smallint", nullable: true)]
    private ?int $daStatus;

    #[Column(name: "d_operator", type: "smallint", nullable: true)]
    private ?int $dOperator;

    #[Column(name: "d_datetime", type: "datetime", nullable: true)]
    private ?DateTime $dDatetime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $purpose;

    #[Column(type: "string", nullable: true)]
    private ?string $label;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $ssd;

    #[Column(name: "shipping_address", type: "text", nullable: true)]
    private ?string $shippingAddress;

    #[Column(name: "req_chat_id", type: "string", nullable: true)]
    private ?string $reqChatId;

    public function __construct()
    {
        $this->companyId = (isset($_GET["CID"]))? $_GET["CID"]:User_Company_ID();
        $this->partnerId = (isset($_GET["PID"]))? $_GET["PID"]:'';
        $this->bom = "Please Update Product Specification i.e. BOM, CBM, Weight/SQM, Price, MOQ etc";
        $this->daStatus = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getOldRef(): ?string
    {
        return HtmlDecode($this->oldRef);
    }

    public function setOldRef(?string $value): static
    {
        $this->oldRef = RemoveXss($value);
        return $this;
    }

    public function getDesign(): string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getColor(): string
    {
        return HtmlDecode($this->color);
    }

    public function setColor(string $value): static
    {
        $this->color = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getDeliveryWeek(): ?int
    {
        return $this->deliveryWeek;
    }

    public function setDeliveryWeek(?int $value): static
    {
        $this->deliveryWeek = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getUpload(): ?string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(?string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getSpRemarks(): ?string
    {
        return HtmlDecode($this->spRemarks);
    }

    public function setSpRemarks(?string $value): static
    {
        $this->spRemarks = RemoveXss($value);
        return $this;
    }

    public function getPpRemarks(): ?string
    {
        return HtmlDecode($this->ppRemarks);
    }

    public function setPpRemarks(?string $value): static
    {
        $this->ppRemarks = RemoveXss($value);
        return $this;
    }

    public function getPoRemarks(): ?string
    {
        return HtmlDecode($this->poRemarks);
    }

    public function setPoRemarks(?string $value): static
    {
        $this->poRemarks = RemoveXss($value);
        return $this;
    }

    public function getPrice(): ?string
    {
        return HtmlDecode($this->price);
    }

    public function setPrice(?string $value): static
    {
        $this->price = RemoveXss($value);
        return $this;
    }

    public function getDeclaration(): ?string
    {
        return HtmlDecode($this->declaration);
    }

    public function setDeclaration(?string $value): static
    {
        $this->declaration = RemoveXss($value);
        return $this;
    }

    public function getDispatch(): ?string
    {
        return HtmlDecode($this->dispatch);
    }

    public function setDispatch(?string $value): static
    {
        $this->dispatch = RemoveXss($value);
        return $this;
    }

    public function getBom(): string
    {
        return HtmlDecode($this->bom);
    }

    public function setBom(string $value): static
    {
        $this->bom = RemoveXss($value);
        return $this;
    }

    public function getDUpload(): ?string
    {
        return HtmlDecode($this->dUpload);
    }

    public function setDUpload(?string $value): static
    {
        $this->dUpload = RemoveXss($value);
        return $this;
    }

    public function getDaComments(): ?string
    {
        return HtmlDecode($this->daComments);
    }

    public function setDaComments(?string $value): static
    {
        $this->daComments = RemoveXss($value);
        return $this;
    }

    public function getDaStatus(): ?int
    {
        return $this->daStatus;
    }

    public function setDaStatus(?int $value): static
    {
        $this->daStatus = $value;
        return $this;
    }

    public function getDOperator(): ?int
    {
        return $this->dOperator;
    }

    public function setDOperator(?int $value): static
    {
        $this->dOperator = $value;
        return $this;
    }

    public function getDDatetime(): ?DateTime
    {
        return $this->dDatetime;
    }

    public function setDDatetime(?DateTime $value): static
    {
        $this->dDatetime = $value;
        return $this;
    }

    public function getPurpose(): ?int
    {
        return $this->purpose;
    }

    public function setPurpose(?int $value): static
    {
        $this->purpose = $value;
        return $this;
    }

    public function getLabel(): ?string
    {
        return HtmlDecode($this->label);
    }

    public function setLabel(?string $value): static
    {
        $this->label = RemoveXss($value);
        return $this;
    }

    public function getSsd(): ?DateTime
    {
        return $this->ssd;
    }

    public function setSsd(?DateTime $value): static
    {
        $this->ssd = $value;
        return $this;
    }

    public function getShippingAddress(): ?string
    {
        return HtmlDecode($this->shippingAddress);
    }

    public function setShippingAddress(?string $value): static
    {
        $this->shippingAddress = RemoveXss($value);
        return $this;
    }

    public function getReqChatId(): ?string
    {
        return HtmlDecode($this->reqChatId);
    }

    public function setReqChatId(?string $value): static
    {
        $this->reqChatId = RemoveXss($value);
        return $this;
    }
}
