<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "sample_req_cart_auth" table
 */
#[Entity]
#[Table(name: "sample_req_cart_auth")]
class SampleReqCartAuth extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "r_text", type: "string", nullable: true)]
    private ?string $rText;

    #[Column(name: "old_ref", type: "string", nullable: true)]
    private ?string $oldRef;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "request_by", type: "smallint")]
    private int $requestBy;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(type: "string", nullable: true)]
    private ?string $upload;

    #[Column(name: "req_chat_id", type: "string", nullable: true)]
    private ?string $reqChatId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "string")]
    private string $design;

    #[Column(type: "string")]
    private string $color;

    #[Column(type: "string")]
    private string $size;

    #[Column(type: "smallint")]
    private int $quantity;

    #[Column(name: "shipping_mode", type: "integer", nullable: true)]
    private ?int $shippingMode;

    #[Column(name: "delivery_week", type: "smallint", nullable: true)]
    private ?int $deliveryWeek;

    #[Column(type: "smallint", nullable: true)]
    private ?int $purpose;

    #[Column(type: "string", nullable: true)]
    private ?string $label;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $ssd;

    #[Column(name: "shipping_address_2", type: "text", nullable: true)]
    private ?string $shippingAddress2;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "sp_remarks", type: "string", nullable: true)]
    private ?string $spRemarks;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    public function __construct()
    {
        $this->requestBy = CurrentUserID();
        $this->companyId = (isset($_GET["CID"]))? $_GET["CID"]:User_Company_ID();
        $this->partnerId = (isset($_GET["PID"]))? $_GET["PID"]:'';
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }

    public function getOldRef(): ?string
    {
        return HtmlDecode($this->oldRef);
    }

    public function setOldRef(?string $value): static
    {
        $this->oldRef = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getRequestBy(): int
    {
        return $this->requestBy;
    }

    public function setRequestBy(int $value): static
    {
        $this->requestBy = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getUpload(): ?string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(?string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getReqChatId(): ?string
    {
        return HtmlDecode($this->reqChatId);
    }

    public function setReqChatId(?string $value): static
    {
        $this->reqChatId = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDesign(): string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getColor(): string
    {
        return HtmlDecode($this->color);
    }

    public function setColor(string $value): static
    {
        $this->color = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getShippingMode(): ?int
    {
        return $this->shippingMode;
    }

    public function setShippingMode(?int $value): static
    {
        $this->shippingMode = $value;
        return $this;
    }

    public function getDeliveryWeek(): ?int
    {
        return $this->deliveryWeek;
    }

    public function setDeliveryWeek(?int $value): static
    {
        $this->deliveryWeek = $value;
        return $this;
    }

    public function getPurpose(): ?int
    {
        return $this->purpose;
    }

    public function setPurpose(?int $value): static
    {
        $this->purpose = $value;
        return $this;
    }

    public function getLabel(): ?string
    {
        return HtmlDecode($this->label);
    }

    public function setLabel(?string $value): static
    {
        $this->label = RemoveXss($value);
        return $this;
    }

    public function getSsd(): ?DateTime
    {
        return $this->ssd;
    }

    public function setSsd(?DateTime $value): static
    {
        $this->ssd = $value;
        return $this;
    }

    public function getShippingAddress2(): ?string
    {
        return HtmlDecode($this->shippingAddress2);
    }

    public function setShippingAddress2(?string $value): static
    {
        $this->shippingAddress2 = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getSpRemarks(): ?string
    {
        return HtmlDecode($this->spRemarks);
    }

    public function setSpRemarks(?string $value): static
    {
        $this->spRemarks = RemoveXss($value);
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }
}
