<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "sample_req_cart_app" table
 */
#[Entity]
#[Table(name: "sample_req_cart_app")]
class SampleReqCartApp extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "old_ref", type: "string", nullable: true)]
    private ?string $oldRef;

    #[Column(type: "string", nullable: true)]
    private ?string $upload;

    #[Column(type: "string")]
    private string $design;

    #[Column(type: "string")]
    private string $color;

    #[Column(type: "string")]
    private string $size;

    #[Column(type: "smallint")]
    private int $quantity;

    #[Column(name: "delivery_week", type: "smallint", nullable: true)]
    private ?int $deliveryWeek;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "sp_remarks", type: "string", nullable: true)]
    private ?string $spRemarks;

    #[Column(name: "pp_remarks", type: "string", nullable: true)]
    private ?string $ppRemarks;

    #[Column(type: "string", nullable: true)]
    private ?string $price;

    #[Column(type: "string", nullable: true)]
    private ?string $declaration;

    #[Column(name: "app_status", type: "smallint")]
    private int $appStatus;

    #[Column(name: "app_operator", type: "smallint", nullable: true)]
    private ?int $appOperator;

    #[Column(name: "app_datetime", type: "datetime", nullable: true)]
    private ?DateTime $appDatetime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(name: "req_chat_id", type: "string", nullable: true)]
    private ?string $reqChatId;

    public function __construct()
    {
        $this->companyId = (isset($_GET["CID"]))? $_GET["CID"]:User_Company_ID();
        $this->partnerId = (isset($_GET["PID"]))? $_GET["PID"]:'';
        $this->appStatus = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getOldRef(): ?string
    {
        return HtmlDecode($this->oldRef);
    }

    public function setOldRef(?string $value): static
    {
        $this->oldRef = RemoveXss($value);
        return $this;
    }

    public function getUpload(): ?string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(?string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getDesign(): string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getColor(): string
    {
        return HtmlDecode($this->color);
    }

    public function setColor(string $value): static
    {
        $this->color = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getDeliveryWeek(): ?int
    {
        return $this->deliveryWeek;
    }

    public function setDeliveryWeek(?int $value): static
    {
        $this->deliveryWeek = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getSpRemarks(): ?string
    {
        return HtmlDecode($this->spRemarks);
    }

    public function setSpRemarks(?string $value): static
    {
        $this->spRemarks = RemoveXss($value);
        return $this;
    }

    public function getPpRemarks(): ?string
    {
        return HtmlDecode($this->ppRemarks);
    }

    public function setPpRemarks(?string $value): static
    {
        $this->ppRemarks = RemoveXss($value);
        return $this;
    }

    public function getPrice(): ?string
    {
        return HtmlDecode($this->price);
    }

    public function setPrice(?string $value): static
    {
        $this->price = RemoveXss($value);
        return $this;
    }

    public function getDeclaration(): ?string
    {
        return HtmlDecode($this->declaration);
    }

    public function setDeclaration(?string $value): static
    {
        $this->declaration = RemoveXss($value);
        return $this;
    }

    public function getAppStatus(): int
    {
        return $this->appStatus;
    }

    public function setAppStatus(int $value): static
    {
        $this->appStatus = $value;
        return $this;
    }

    public function getAppOperator(): ?int
    {
        return $this->appOperator;
    }

    public function setAppOperator(?int $value): static
    {
        $this->appOperator = $value;
        return $this;
    }

    public function getAppDatetime(): ?DateTime
    {
        return $this->appDatetime;
    }

    public function setAppDatetime(?DateTime $value): static
    {
        $this->appDatetime = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getReqChatId(): ?string
    {
        return HtmlDecode($this->reqChatId);
    }

    public function setReqChatId(?string $value): static
    {
        $this->reqChatId = RemoveXss($value);
        return $this;
    }
}
