<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "salary_expenses" table
 */
#[Entity]
#[Table(name: "salary_expenses")]
class SalaryExpense extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "employee_id", type: "smallint")]
    private int $employeeId;

    #[Column(name: "expense_type", type: "smallint")]
    private int $expenseType;

    #[Column(name: "expense_sub_type", type: "smallint", nullable: true)]
    private ?int $expenseSubType;

    #[Column(name: "basic_salary", type: "decimal")]
    private string $basicSalary;

    #[Column(name: "ded_add", type: "decimal")]
    private string $dedAdd;

    #[Column(name: "final_amount", type: "decimal")]
    private string $finalAmount;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->basicSalary = "0.00";
        $this->dedAdd = "0.00";
        $this->finalAmount = "0";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getExpenseType(): int
    {
        return $this->expenseType;
    }

    public function setExpenseType(int $value): static
    {
        $this->expenseType = $value;
        return $this;
    }

    public function getExpenseSubType(): ?int
    {
        return $this->expenseSubType;
    }

    public function setExpenseSubType(?int $value): static
    {
        $this->expenseSubType = $value;
        return $this;
    }

    public function getBasicSalary(): string
    {
        return $this->basicSalary;
    }

    public function setBasicSalary(string $value): static
    {
        $this->basicSalary = $value;
        return $this;
    }

    public function getDedAdd(): string
    {
        return $this->dedAdd;
    }

    public function setDedAdd(string $value): static
    {
        $this->dedAdd = $value;
        return $this;
    }

    public function getFinalAmount(): string
    {
        return $this->finalAmount;
    }

    public function setFinalAmount(string $value): static
    {
        $this->finalAmount = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
