<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "s_student_list" table
 */
#[Entity]
#[Table(name: "s_student_list")]
class SStudentList extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", nullable: true)]
    #[GeneratedValue]
    private ?int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "sr_no", type: "string", nullable: true)]
    private ?string $srNo;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "fac_sec", type: "string", nullable: true)]
    private ?string $facSec;

    #[Column(name: "father_name", type: "string", nullable: true)]
    private ?string $fatherName;

    #[Column(name: "mother_name", type: "string", nullable: true)]
    private ?string $motherName;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(name: "mobile_other", type: "string", nullable: true)]
    private ?string $mobileOther;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "string", nullable: true)]
    private ?string $gender;

    #[Column(type: "string", nullable: true)]
    private ?string $category;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $doj;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(name: "idcard_status", type: "smallint", nullable: true)]
    private ?int $idcardStatus;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    #[GeneratedValue]
    private ?int $faculty;

    #[Column(type: "string", nullable: true)]
    private ?string $epc;

    public function __construct()
    {
        $this->idcardStatus = 0;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getSrNo(): ?string
    {
        return HtmlDecode($this->srNo);
    }

    public function setSrNo(?string $value): static
    {
        $this->srNo = RemoveXss($value);
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getFacSec(): ?string
    {
        return HtmlDecode($this->facSec);
    }

    public function setFacSec(?string $value): static
    {
        $this->facSec = RemoveXss($value);
        return $this;
    }

    public function getFatherName(): ?string
    {
        return HtmlDecode($this->fatherName);
    }

    public function setFatherName(?string $value): static
    {
        $this->fatherName = RemoveXss($value);
        return $this;
    }

    public function getMotherName(): ?string
    {
        return HtmlDecode($this->motherName);
    }

    public function setMotherName(?string $value): static
    {
        $this->motherName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getMobileOther(): ?string
    {
        return HtmlDecode($this->mobileOther);
    }

    public function setMobileOther(?string $value): static
    {
        $this->mobileOther = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getDoj(): ?DateTime
    {
        return $this->doj;
    }

    public function setDoj(?DateTime $value): static
    {
        $this->doj = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getIdcardStatus(): ?int
    {
        return $this->idcardStatus;
    }

    public function setIdcardStatus(?int $value): static
    {
        $this->idcardStatus = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getFaculty(): ?int
    {
        return $this->faculty;
    }

    public function setFaculty(?int $value): static
    {
        $this->faculty = $value;
        return $this;
    }

    public function getEpc(): ?string
    {
        return HtmlDecode($this->epc);
    }

    public function setEpc(?string $value): static
    {
        $this->epc = RemoveXss($value);
        return $this;
    }
}
