<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "s_inout_time" table
 */
#[Entity]
#[Table(name: "s_inout_time")]
class SInoutTime extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "week_day", type: "string", nullable: true)]
    private ?string $weekDay;

    #[Column(name: "in_time", type: "time")]
    private DateTime $inTime;

    #[Column(name: "out_time", type: "time")]
    private DateTime $outTime;

    #[Column(type: "string")]
    private string $faculty;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWeekDay(): ?string
    {
        return HtmlDecode($this->weekDay);
    }

    public function setWeekDay(?string $value): static
    {
        $this->weekDay = RemoveXss($value);
        return $this;
    }

    public function getInTime(): DateTime
    {
        return $this->inTime;
    }

    public function setInTime(DateTime $value): static
    {
        $this->inTime = $value;
        return $this;
    }

    public function getOutTime(): DateTime
    {
        return $this->outTime;
    }

    public function setOutTime(DateTime $value): static
    {
        $this->outTime = $value;
        return $this;
    }

    public function getFaculty(): string
    {
        return HtmlDecode($this->faculty);
    }

    public function setFaculty(string $value): static
    {
        $this->faculty = RemoveXss($value);
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
