<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "s_faculty" table
 */
#[Entity]
#[Table(name: "s_faculty")]
class SFaculty extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $type;

    #[Column(type: "string", nullable: true)]
    private ?string $faculty;

    #[Column(type: "string", nullable: true)]
    private ?string $section;

    #[Column(name: "fac_sec", type: "string", nullable: true)]
    private ?string $facSec;

    #[Column(type: "string", nullable: true)]
    private ?string $session;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sort;

    public function __construct()
    {
        $this->type = 0;
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getFaculty(): ?string
    {
        return HtmlDecode($this->faculty);
    }

    public function setFaculty(?string $value): static
    {
        $this->faculty = RemoveXss($value);
        return $this;
    }

    public function getSection(): ?string
    {
        return HtmlDecode($this->section);
    }

    public function setSection(?string $value): static
    {
        $this->section = RemoveXss($value);
        return $this;
    }

    public function getFacSec(): ?string
    {
        return HtmlDecode($this->facSec);
    }

    public function setFacSec(?string $value): static
    {
        $this->facSec = RemoveXss($value);
        return $this;
    }

    public function getSession(): ?string
    {
        return HtmlDecode($this->session);
    }

    public function setSession(?string $value): static
    {
        $this->session = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getSort(): ?string
    {
        return $this->sort;
    }

    public function setSort(?string $value): static
    {
        $this->sort = $value;
        return $this;
    }
}
