<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "s_eval_scheme" table
 */
#[Entity]
#[Table(name: "s_eval_scheme")]
class SEvalScheme extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $description;

    #[Column(name: "test_id", type: "string")]
    private string $testId;

    #[Column(type: "string", nullable: true)]
    private ?string $sec;

    #[Column(name: "no_start_end", type: "string", nullable: true)]
    private ?string $noStartEnd;

    #[Column(name: "to_attempt", type: "smallint", nullable: true)]
    private ?int $toAttempt;

    #[Column(type: "decimal", nullable: true)]
    private ?string $marks;

    #[Column(name: "n_marks", type: "decimal", nullable: true)]
    private ?string $nMarks;

    #[Column(name: "t_marks", type: "decimal")]
    private string $tMarks;

    #[Column(name: "answer_key", type: "string", nullable: true)]
    private ?string $answerKey;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getTestId(): string
    {
        return HtmlDecode($this->testId);
    }

    public function setTestId(string $value): static
    {
        $this->testId = RemoveXss($value);
        return $this;
    }

    public function getSec(): ?string
    {
        return HtmlDecode($this->sec);
    }

    public function setSec(?string $value): static
    {
        $this->sec = RemoveXss($value);
        return $this;
    }

    public function getNoStartEnd(): ?string
    {
        return HtmlDecode($this->noStartEnd);
    }

    public function setNoStartEnd(?string $value): static
    {
        $this->noStartEnd = RemoveXss($value);
        return $this;
    }

    public function getToAttempt(): ?int
    {
        return $this->toAttempt;
    }

    public function setToAttempt(?int $value): static
    {
        $this->toAttempt = $value;
        return $this;
    }

    public function getMarks(): ?string
    {
        return $this->marks;
    }

    public function setMarks(?string $value): static
    {
        $this->marks = $value;
        return $this;
    }

    public function getNMarks(): ?string
    {
        return $this->nMarks;
    }

    public function setNMarks(?string $value): static
    {
        $this->nMarks = $value;
        return $this;
    }

    public function getTMarks(): string
    {
        return $this->tMarks;
    }

    public function setTMarks(string $value): static
    {
        $this->tMarks = $value;
        return $this;
    }

    public function getAnswerKey(): ?string
    {
        return HtmlDecode($this->answerKey);
    }

    public function setAnswerKey(?string $value): static
    {
        $this->answerKey = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
