<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "s_epc_live" table
 */
#[Entity]
#[Table(name: "s_epc_live")]
class SEpcLive extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $epc;

    #[Column(name: "inout_datetime", type: "datetime", nullable: true)]
    private ?DateTime $inoutDatetime;

    #[Column(name: "in_out", type: "string", nullable: true)]
    private ?string $inOut;

    #[Column(name: "unit_id", type: "smallint", nullable: true)]
    private ?int $unitId;

    #[Column(name: "s_pid", type: "string", nullable: true)]
    private ?string $sPid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $faculty;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(name: "m_type", type: "smallint", nullable: true)]
    private ?int $mType;

    #[Column(name: "m_status", type: "smallint", nullable: true)]
    private ?int $mStatus;

    #[Column(name: "m_datetime", type: "datetime", nullable: true)]
    private ?DateTime $mDatetime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "string", nullable: true)]
    private ?string $uid;

    #[Column(name: "s_name", type: "string", nullable: true)]
    private ?string $sName;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getEpc(): ?string
    {
        return HtmlDecode($this->epc);
    }

    public function setEpc(?string $value): static
    {
        $this->epc = RemoveXss($value);
        return $this;
    }

    public function getInoutDatetime(): ?DateTime
    {
        return $this->inoutDatetime;
    }

    public function setInoutDatetime(?DateTime $value): static
    {
        $this->inoutDatetime = $value;
        return $this;
    }

    public function getInOut(): ?string
    {
        return HtmlDecode($this->inOut);
    }

    public function setInOut(?string $value): static
    {
        $this->inOut = RemoveXss($value);
        return $this;
    }

    public function getUnitId(): ?int
    {
        return $this->unitId;
    }

    public function setUnitId(?int $value): static
    {
        $this->unitId = $value;
        return $this;
    }

    public function getSPid(): ?string
    {
        return HtmlDecode($this->sPid);
    }

    public function setSPid(?string $value): static
    {
        $this->sPid = RemoveXss($value);
        return $this;
    }

    public function getFaculty(): ?int
    {
        return $this->faculty;
    }

    public function setFaculty(?int $value): static
    {
        $this->faculty = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getMType(): ?int
    {
        return $this->mType;
    }

    public function setMType(?int $value): static
    {
        $this->mType = $value;
        return $this;
    }

    public function getMStatus(): ?int
    {
        return $this->mStatus;
    }

    public function setMStatus(?int $value): static
    {
        $this->mStatus = $value;
        return $this;
    }

    public function getMDatetime(): ?DateTime
    {
        return $this->mDatetime;
    }

    public function setMDatetime(?DateTime $value): static
    {
        $this->mDatetime = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUid(): ?string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(?string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }

    public function getSName(): ?string
    {
        return HtmlDecode($this->sName);
    }

    public function setSName(?string $value): static
    {
        $this->sName = RemoveXss($value);
        return $this;
    }
}
