<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "s_attendance_info" table
 */
#[Entity]
#[Table(name: "s_attendance_info")]
class SAttendanceInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "s_pid", type: "smallint", nullable: true)]
    private ?int $sPid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $faculty;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "in_time", type: "datetime", nullable: true)]
    private ?DateTime $inTime;

    #[Column(name: "in_out_in", type: "string", nullable: true)]
    private ?string $inOutIn;

    #[Column(name: "in_m_status", type: "smallint", nullable: true)]
    private ?int $inMStatus;

    #[Column(name: "in_unit", type: "smallint", nullable: true)]
    private ?int $inUnit;

    #[Column(name: "out_time", type: "datetime", nullable: true)]
    private ?DateTime $outTime;

    #[Column(name: "in_out_out", type: "string", nullable: true)]
    private ?string $inOutOut;

    #[Column(name: "out_m_status", type: "smallint", nullable: true)]
    private ?int $outMStatus;

    #[Column(name: "out_unit", type: "smallint", nullable: true)]
    private ?int $outUnit;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSPid(): ?int
    {
        return $this->sPid;
    }

    public function setSPid(?int $value): static
    {
        $this->sPid = $value;
        return $this;
    }

    public function getFaculty(): ?int
    {
        return $this->faculty;
    }

    public function setFaculty(?int $value): static
    {
        $this->faculty = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getInTime(): ?DateTime
    {
        return $this->inTime;
    }

    public function setInTime(?DateTime $value): static
    {
        $this->inTime = $value;
        return $this;
    }

    public function getInOutIn(): ?string
    {
        return HtmlDecode($this->inOutIn);
    }

    public function setInOutIn(?string $value): static
    {
        $this->inOutIn = RemoveXss($value);
        return $this;
    }

    public function getInMStatus(): ?int
    {
        return $this->inMStatus;
    }

    public function setInMStatus(?int $value): static
    {
        $this->inMStatus = $value;
        return $this;
    }

    public function getInUnit(): ?int
    {
        return $this->inUnit;
    }

    public function setInUnit(?int $value): static
    {
        $this->inUnit = $value;
        return $this;
    }

    public function getOutTime(): ?DateTime
    {
        return $this->outTime;
    }

    public function setOutTime(?DateTime $value): static
    {
        $this->outTime = $value;
        return $this;
    }

    public function getInOutOut(): ?string
    {
        return HtmlDecode($this->inOutOut);
    }

    public function setInOutOut(?string $value): static
    {
        $this->inOutOut = RemoveXss($value);
        return $this;
    }

    public function getOutMStatus(): ?int
    {
        return $this->outMStatus;
    }

    public function setOutMStatus(?int $value): static
    {
        $this->outMStatus = $value;
        return $this;
    }

    public function getOutUnit(): ?int
    {
        return $this->outUnit;
    }

    public function setOutUnit(?int $value): static
    {
        $this->outUnit = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }
}
