<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "s_admission_info" table
 */
#[Entity]
#[Table(name: "s_admission_info")]
class SAdmissionInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "s_pid", type: "smallint")]
    private int $sPid;

    #[Column(type: "smallint")]
    private int $faculty;

    #[Column(name: "admission_year", type: "smallint")]
    private int $admissionYear;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(type: "text", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $path;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $uid;

    public function __construct()
    {
        $this->admissionYear = 2025;
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSPid(): int
    {
        return $this->sPid;
    }

    public function setSPid(int $value): static
    {
        $this->sPid = $value;
        return $this;
    }

    public function getFaculty(): int
    {
        return $this->faculty;
    }

    public function setFaculty(int $value): static
    {
        $this->faculty = $value;
        return $this;
    }

    public function getAdmissionYear(): int
    {
        return $this->admissionYear;
    }

    public function setAdmissionYear(int $value): static
    {
        $this->admissionYear = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPath(): ?string
    {
        return HtmlDecode($this->path);
    }

    public function setPath(?string $value): static
    {
        $this->path = RemoveXss($value);
        return $this;
    }

    public function getUid(): ?string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(?string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
