<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "required_material_overall_table" table
 */
#[Entity]
#[Table(name: "required_material_overall_table")]
class RequiredMaterialOverallTable extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "decimal", nullable: true)]
    private ?string $pending;

    #[Column(name: "req_material_grp", type: "smallint", nullable: true)]
    private ?int $reqMaterialGrp;

    #[Column(name: "req_material_sgrp", type: "smallint")]
    private int $reqMaterialSgrp;

    #[Column(name: "req_material_product", type: "smallint", nullable: true)]
    private ?int $reqMaterialProduct;

    #[Column(name: "req_material_rid", type: "smallint", nullable: true)]
    private ?int $reqMaterialRid;

    #[Column(name: "req_material_packing", type: "smallint", nullable: true)]
    private ?int $reqMaterialPacking;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(type: "text", nullable: true)]
    private ?string $unit;

    #[Column(type: "decimal", nullable: true)]
    private ?string $mil;

    #[Column(name: "req_material_qty", type: "decimal", nullable: true)]
    private ?string $reqMaterialQty;

    #[Column(name: "po_s_pending", type: "decimal", nullable: true)]
    private ?string $poSPending;

    #[Column(name: "po_pending_wbc", type: "decimal", nullable: true)]
    private ?string $poPendingWbc;

    #[Column(name: "not_loomcard", type: "decimal", nullable: true)]
    private ?string $notLoomcard;

    #[Column(type: "decimal", nullable: true)]
    private ?string $stock;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(name: "last_supplier_id", type: "integer")]
    private int $lastSupplierId;

    #[Column(name: "internal_external", type: "integer", nullable: true)]
    private ?int $internalExternal;

    public function __construct()
    {
        $this->mil = "0.000";
        $this->poSPending = "0.000";
        $this->notLoomcard = "0.000";
        $this->stock = "0.000";
        $this->internalExternal = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPending(): ?string
    {
        return $this->pending;
    }

    public function setPending(?string $value): static
    {
        $this->pending = $value;
        return $this;
    }

    public function getReqMaterialGrp(): ?int
    {
        return $this->reqMaterialGrp;
    }

    public function setReqMaterialGrp(?int $value): static
    {
        $this->reqMaterialGrp = $value;
        return $this;
    }

    public function getReqMaterialSgrp(): int
    {
        return $this->reqMaterialSgrp;
    }

    public function setReqMaterialSgrp(int $value): static
    {
        $this->reqMaterialSgrp = $value;
        return $this;
    }

    public function getReqMaterialProduct(): ?int
    {
        return $this->reqMaterialProduct;
    }

    public function setReqMaterialProduct(?int $value): static
    {
        $this->reqMaterialProduct = $value;
        return $this;
    }

    public function getReqMaterialRid(): ?int
    {
        return $this->reqMaterialRid;
    }

    public function setReqMaterialRid(?int $value): static
    {
        $this->reqMaterialRid = $value;
        return $this;
    }

    public function getReqMaterialPacking(): ?int
    {
        return $this->reqMaterialPacking;
    }

    public function setReqMaterialPacking(?int $value): static
    {
        $this->reqMaterialPacking = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getUnit(): ?string
    {
        return HtmlDecode($this->unit);
    }

    public function setUnit(?string $value): static
    {
        $this->unit = RemoveXss($value);
        return $this;
    }

    public function getMil(): ?string
    {
        return $this->mil;
    }

    public function setMil(?string $value): static
    {
        $this->mil = $value;
        return $this;
    }

    public function getReqMaterialQty(): ?string
    {
        return $this->reqMaterialQty;
    }

    public function setReqMaterialQty(?string $value): static
    {
        $this->reqMaterialQty = $value;
        return $this;
    }

    public function getPoSPending(): ?string
    {
        return $this->poSPending;
    }

    public function setPoSPending(?string $value): static
    {
        $this->poSPending = $value;
        return $this;
    }

    public function getPoPendingWbc(): ?string
    {
        return $this->poPendingWbc;
    }

    public function setPoPendingWbc(?string $value): static
    {
        $this->poPendingWbc = $value;
        return $this;
    }

    public function getNotLoomcard(): ?string
    {
        return $this->notLoomcard;
    }

    public function setNotLoomcard(?string $value): static
    {
        $this->notLoomcard = $value;
        return $this;
    }

    public function getStock(): ?string
    {
        return $this->stock;
    }

    public function setStock(?string $value): static
    {
        $this->stock = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getLastSupplierId(): int
    {
        return $this->lastSupplierId;
    }

    public function setLastSupplierId(int $value): static
    {
        $this->lastSupplierId = $value;
        return $this;
    }

    public function getInternalExternal(): ?int
    {
        return $this->internalExternal;
    }

    public function setInternalExternal(?int $value): static
    {
        $this->internalExternal = $value;
        return $this;
    }
}
