<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "required_material_compiled_live" table
 */
#[Entity]
#[Table(name: "required_material_compiled_live")]
class RequiredMaterialCompiledLive extends AbstractEntity
{
    #[Column(type: "text", nullable: true)]
    private ?string $week;

    #[Column(name: "weaving_works", type: "smallint", nullable: true)]
    private ?int $weavingWorks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(name: "buyer_id", type: "text", nullable: true)]
    private ?string $buyerId;

    #[Column(name: "req_material_sgrp", type: "smallint", nullable: true)]
    private ?int $reqMaterialSgrp;

    #[Column(name: "req_material_product", type: "smallint", nullable: true)]
    private ?int $reqMaterialProduct;

    #[Column(name: "req_material_rid", type: "smallint", nullable: true)]
    private ?int $reqMaterialRid;

    #[Column(name: "req_material_packing", type: "smallint")]
    private int $reqMaterialPacking;

    #[Column(name: "req_material_qty", type: "decimal", nullable: true)]
    private ?string $reqMaterialQty;

    #[Column(type: "decimal", nullable: true)]
    private ?string $stock;

    #[Column(type: "string", nullable: true)]
    private ?string $unit;

    #[Column(name: "batch_no", type: "text", nullable: true)]
    private ?string $batchNo;

    #[Column(name: "req_batch_no", type: "text", nullable: true)]
    private ?string $reqBatchNo;

    #[Column(name: "pp_id", type: "integer", nullable: true)]
    private ?int $ppId;

    #[Column(type: "integer", nullable: true)]
    private ?int $level;

    #[Column(name: "req_material_grp", type: "smallint", nullable: true)]
    private ?int $reqMaterialGrp;

    public function __construct()
    {
        $this->ppId = 0;
    }

    public function getWeek(): ?string
    {
        return HtmlDecode($this->week);
    }

    public function setWeek(?string $value): static
    {
        $this->week = RemoveXss($value);
        return $this;
    }

    public function getWeavingWorks(): ?int
    {
        return $this->weavingWorks;
    }

    public function setWeavingWorks(?int $value): static
    {
        $this->weavingWorks = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBuyerId(): ?string
    {
        return HtmlDecode($this->buyerId);
    }

    public function setBuyerId(?string $value): static
    {
        $this->buyerId = RemoveXss($value);
        return $this;
    }

    public function getReqMaterialSgrp(): ?int
    {
        return $this->reqMaterialSgrp;
    }

    public function setReqMaterialSgrp(?int $value): static
    {
        $this->reqMaterialSgrp = $value;
        return $this;
    }

    public function getReqMaterialProduct(): ?int
    {
        return $this->reqMaterialProduct;
    }

    public function setReqMaterialProduct(?int $value): static
    {
        $this->reqMaterialProduct = $value;
        return $this;
    }

    public function getReqMaterialRid(): ?int
    {
        return $this->reqMaterialRid;
    }

    public function setReqMaterialRid(?int $value): static
    {
        $this->reqMaterialRid = $value;
        return $this;
    }

    public function getReqMaterialPacking(): int
    {
        return $this->reqMaterialPacking;
    }

    public function setReqMaterialPacking(int $value): static
    {
        $this->reqMaterialPacking = $value;
        return $this;
    }

    public function getReqMaterialQty(): ?string
    {
        return $this->reqMaterialQty;
    }

    public function setReqMaterialQty(?string $value): static
    {
        $this->reqMaterialQty = $value;
        return $this;
    }

    public function getStock(): ?string
    {
        return $this->stock;
    }

    public function setStock(?string $value): static
    {
        $this->stock = $value;
        return $this;
    }

    public function getUnit(): ?string
    {
        return HtmlDecode($this->unit);
    }

    public function setUnit(?string $value): static
    {
        $this->unit = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?string
    {
        return HtmlDecode($this->batchNo);
    }

    public function setBatchNo(?string $value): static
    {
        $this->batchNo = RemoveXss($value);
        return $this;
    }

    public function getReqBatchNo(): ?string
    {
        return HtmlDecode($this->reqBatchNo);
    }

    public function setReqBatchNo(?string $value): static
    {
        $this->reqBatchNo = RemoveXss($value);
        return $this;
    }

    public function getPpId(): ?int
    {
        return $this->ppId;
    }

    public function setPpId(?int $value): static
    {
        $this->ppId = $value;
        return $this;
    }

    public function getLevel(): ?int
    {
        return $this->level;
    }

    public function setLevel(?int $value): static
    {
        $this->level = $value;
        return $this;
    }

    public function getReqMaterialGrp(): ?int
    {
        return $this->reqMaterialGrp;
    }

    public function setReqMaterialGrp(?int $value): static
    {
        $this->reqMaterialGrp = $value;
        return $this;
    }
}
