<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "request_archive" table
 */
#[Entity]
#[Table(name: "request_archive")]
class RequestArchive extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $id;

    #[Column(name: "r_from", type: "text", nullable: true)]
    private ?string $rFrom;

    #[Column(name: "r_to", type: "text", nullable: true)]
    private ?string $rTo;

    #[Column(type: "decimal")]
    private string $reference;

    #[Column(type: "text", nullable: true)]
    private ?string $message;

    #[Column(type: "text", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(name: "Subject", type: "string")]
    private string $subject;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "QueryGenerator", type: "string", nullable: true)]
    private ?string $queryGenerator;

    #[Column(name: "lead_by", type: "string", nullable: true)]
    private ?string $leadBy;

    #[Column(name: "lead_status", type: "smallint", nullable: true)]
    private ?int $leadStatus;

    #[Column(name: "lead_type", type: "smallint", nullable: true)]
    private ?int $leadType;

    #[Column(type: "integer")]
    private int $type;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $alert;

    #[Column(type: "string", nullable: true)]
    private ?string $beep;

    public function __construct()
    {
        $this->reference = "0";
        $this->type = 0;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRFrom(): ?string
    {
        return HtmlDecode($this->rFrom);
    }

    public function setRFrom(?string $value): static
    {
        $this->rFrom = RemoveXss($value);
        return $this;
    }

    public function getRTo(): ?string
    {
        return HtmlDecode($this->rTo);
    }

    public function setRTo(?string $value): static
    {
        $this->rTo = RemoveXss($value);
        return $this;
    }

    public function getReference(): string
    {
        return $this->reference;
    }

    public function setReference(string $value): static
    {
        $this->reference = $value;
        return $this;
    }

    public function getMessage(): ?string
    {
        return HtmlDecode($this->message);
    }

    public function setMessage(?string $value): static
    {
        $this->message = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getSubject(): string
    {
        return HtmlDecode($this->subject);
    }

    public function setSubject(string $value): static
    {
        $this->subject = RemoveXss($value);
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getQueryGenerator(): ?string
    {
        return HtmlDecode($this->queryGenerator);
    }

    public function setQueryGenerator(?string $value): static
    {
        $this->queryGenerator = RemoveXss($value);
        return $this;
    }

    public function getLeadBy(): ?string
    {
        return HtmlDecode($this->leadBy);
    }

    public function setLeadBy(?string $value): static
    {
        $this->leadBy = RemoveXss($value);
        return $this;
    }

    public function getLeadStatus(): ?int
    {
        return $this->leadStatus;
    }

    public function setLeadStatus(?int $value): static
    {
        $this->leadStatus = $value;
        return $this;
    }

    public function getLeadType(): ?int
    {
        return $this->leadType;
    }

    public function setLeadType(?int $value): static
    {
        $this->leadType = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getAlert(): ?DateTime
    {
        return $this->alert;
    }

    public function setAlert(?DateTime $value): static
    {
        $this->alert = $value;
        return $this;
    }

    public function getBeep(): ?string
    {
        return HtmlDecode($this->beep);
    }

    public function setBeep(?string $value): static
    {
        $this->beep = RemoveXss($value);
        return $this;
    }
}
