<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "request" table
 */
#[Entity]
#[Table(name: "request")]
class Request extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $type;

    #[Column(name: "r_from", type: "string")]
    private string $rFrom;

    #[Column(name: "r_to", type: "string")]
    private string $rTo;

    #[Column(name: "lead_type", type: "smallint", nullable: true)]
    private ?int $leadType;

    #[Column(name: "lead_status", type: "smallint", nullable: true)]
    private ?int $leadStatus;

    #[Column(name: "lead_by", type: "string", nullable: true)]
    private ?string $leadBy;

    #[Column(type: "string")]
    private string $subject;

    #[Column(type: "text")]
    private string $message;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $alert;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint")]
    private int $reference;

    #[Column(type: "smallint")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $beep;

    #[Column(name: "c_message", type: "string", nullable: true)]
    private ?string $cMessage;

    public function __construct()
    {
        $this->type = ((isset($_GET["type"]))? $_GET["type"]:((isset($_COOKIE["type"]))? $_COOKIE["type"]:0));
        $this->rTo = (isset($_GET["to"]))? $_GET["to"]:0;
        $this->leadType = (isset($_GET["ltype"]))? $_GET["ltype"]:'';
        $this->leadStatus = (isset($_GET["sta"]))? $_GET["sta"]:'';
        $this->leadBy = (isset($_GET["leadby"]))? $_GET["leadby"]:'';
        $this->subject = (isset($_GET["sub"]))? $_GET["sub"]:'';
        $this->reference = (isset($_GET["ref"]))? $_GET["ref"]:0;
        $this->operator = 0;
        $this->beep = "0";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getRFrom(): string
    {
        return HtmlDecode($this->rFrom);
    }

    public function setRFrom(string $value): static
    {
        $this->rFrom = RemoveXss($value);
        return $this;
    }

    public function getRTo(): string
    {
        return HtmlDecode($this->rTo);
    }

    public function setRTo(string $value): static
    {
        $this->rTo = RemoveXss($value);
        return $this;
    }

    public function getLeadType(): ?int
    {
        return $this->leadType;
    }

    public function setLeadType(?int $value): static
    {
        $this->leadType = $value;
        return $this;
    }

    public function getLeadStatus(): ?int
    {
        return $this->leadStatus;
    }

    public function setLeadStatus(?int $value): static
    {
        $this->leadStatus = $value;
        return $this;
    }

    public function getLeadBy(): ?string
    {
        return HtmlDecode($this->leadBy);
    }

    public function setLeadBy(?string $value): static
    {
        $this->leadBy = RemoveXss($value);
        return $this;
    }

    public function getSubject(): string
    {
        return HtmlDecode($this->subject);
    }

    public function setSubject(string $value): static
    {
        $this->subject = RemoveXss($value);
        return $this;
    }

    public function getMessage(): string
    {
        return HtmlDecode($this->message);
    }

    public function setMessage(string $value): static
    {
        $this->message = RemoveXss($value);
        return $this;
    }

    public function getAlert(): ?DateTime
    {
        return $this->alert;
    }

    public function setAlert(?DateTime $value): static
    {
        $this->alert = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getReference(): int
    {
        return $this->reference;
    }

    public function setReference(int $value): static
    {
        $this->reference = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getBeep(): ?string
    {
        return HtmlDecode($this->beep);
    }

    public function setBeep(?string $value): static
    {
        $this->beep = RemoveXss($value);
        return $this;
    }

    public function getCMessage(): ?string
    {
        return HtmlDecode($this->cMessage);
    }

    public function setCMessage(?string $value): static
    {
        $this->cMessage = RemoveXss($value);
        return $this;
    }
}
