<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "rental_po" table
 */
#[Entity]
#[Table(name: "rental_po")]
class RentalPo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "programme_datetime", type: "datetime", nullable: true)]
    private ?DateTime $programmeDatetime;

    #[Column(name: "programme_end_datetime", type: "datetime", nullable: true)]
    private ?DateTime $programmeEndDatetime;

    #[Column(type: "string", nullable: true)]
    private ?string $location;

    #[Column(type: "string")]
    private string $item;

    #[Column(name: "contact_person", type: "string")]
    private string $contactPerson;

    #[Column(type: "string")]
    private string $amount;

    #[Column(name: "booking_ref", type: "string", nullable: true)]
    private ?string $bookingRef;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "payment_terms", type: "string", nullable: true)]
    private ?string $paymentTerms;

    #[Column(name: "job_category", type: "integer")]
    private int $jobCategory;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(name: "buyer_instruction", type: "string", nullable: true)]
    private ?string $buyerInstruction;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "eastimated_amount", type: "decimal", nullable: true)]
    private ?string $eastimatedAmount;

    #[Column(type: "smallint")]
    private int $gst;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(name: "reports_to", type: "smallint", nullable: true)]
    private ?int $reportsTo;

    #[Column(name: "description_01", type: "string", nullable: true)]
    private ?string $description01;

    #[Column(name: "description_02", type: "string", nullable: true)]
    private ?string $description02;

    #[Column(name: "description_03", type: "string", nullable: true)]
    private ?string $description03;

    #[Column(name: "description_04", type: "string", nullable: true)]
    private ?string $description04;

    #[Column(name: "description_05", type: "string", nullable: true)]
    private ?string $description05;

    #[Column(name: "description_06", type: "string", nullable: true)]
    private ?string $description06;

    #[Column(name: "description_07", type: "string", nullable: true)]
    private ?string $description07;

    #[Column(name: "description_08", type: "string", nullable: true)]
    private ?string $description08;

    #[Column(name: "description_09", type: "string", nullable: true)]
    private ?string $description09;

    #[Column(name: "description_10", type: "string", nullable: true)]
    private ?string $description10;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    public function __construct()
    {
        $this->item = (isset($_COOKIE["ITEM"]))? $_COOKIE["ITEM"]:'';
        $this->amount = (isset($_COOKIE["AMT"]))? $_COOKIE["AMT"]:'0';
        $this->companyId = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID()));
        $this->jobCategory = (isset($_COOKIE["CAT"]))? $_COOKIE["CAT"]:'';
        $this->type = 1;
        $this->buyerInstruction = (isset($_COOKIE["BI"]))? $_COOKIE["BI"]:'';
        $this->remarks = (isset($_COOKIE["REM"]))? $_COOKIE["REM"]:'';
        $this->eastimatedAmount = "0";
        $this->gst = (isset($_COOKIE["GST"]))? $_COOKIE["GST"]:'1';
        $this->description01 = (isset($_COOKIE["D01"]))? $_COOKIE["D01"]:'';
        $this->description02 = (isset($_COOKIE["D02"]))? $_COOKIE["D02"]:'';
        $this->description03 = (isset($_COOKIE["D03"]))? $_COOKIE["D03"]:'';
        $this->description04 = (isset($_COOKIE["D04"]))? $_COOKIE["D04"]:'';
        $this->description05 = (isset($_COOKIE["D05"]))? $_COOKIE["D05"]:'';
        $this->description06 = (isset($_COOKIE["D06"]))? $_COOKIE["D06"]:'';
        $this->description07 = (isset($_COOKIE["D07"]))? $_COOKIE["D07"]:'';
        $this->description08 = (isset($_COOKIE["D08"]))? $_COOKIE["D08"]:'';
        $this->description09 = (isset($_COOKIE["D09"]))? $_COOKIE["D09"]:'';
        $this->description10 = (isset($_COOKIE["D10"]))? $_COOKIE["D10"]:'';
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getProgrammeDatetime(): ?DateTime
    {
        return $this->programmeDatetime;
    }

    public function setProgrammeDatetime(?DateTime $value): static
    {
        $this->programmeDatetime = $value;
        return $this;
    }

    public function getProgrammeEndDatetime(): ?DateTime
    {
        return $this->programmeEndDatetime;
    }

    public function setProgrammeEndDatetime(?DateTime $value): static
    {
        $this->programmeEndDatetime = $value;
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getItem(): string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getContactPerson(): string
    {
        return HtmlDecode($this->contactPerson);
    }

    public function setContactPerson(string $value): static
    {
        $this->contactPerson = RemoveXss($value);
        return $this;
    }

    public function getAmount(): string
    {
        return HtmlDecode($this->amount);
    }

    public function setAmount(string $value): static
    {
        $this->amount = RemoveXss($value);
        return $this;
    }

    public function getBookingRef(): ?string
    {
        return HtmlDecode($this->bookingRef);
    }

    public function setBookingRef(?string $value): static
    {
        $this->bookingRef = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPaymentTerms(): ?string
    {
        return HtmlDecode($this->paymentTerms);
    }

    public function setPaymentTerms(?string $value): static
    {
        $this->paymentTerms = RemoveXss($value);
        return $this;
    }

    public function getJobCategory(): int
    {
        return $this->jobCategory;
    }

    public function setJobCategory(int $value): static
    {
        $this->jobCategory = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getBuyerInstruction(): ?string
    {
        return HtmlDecode($this->buyerInstruction);
    }

    public function setBuyerInstruction(?string $value): static
    {
        $this->buyerInstruction = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getEastimatedAmount(): ?string
    {
        return $this->eastimatedAmount;
    }

    public function setEastimatedAmount(?string $value): static
    {
        $this->eastimatedAmount = $value;
        return $this;
    }

    public function getGst(): int
    {
        return $this->gst;
    }

    public function setGst(int $value): static
    {
        $this->gst = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getDescription01(): ?string
    {
        return HtmlDecode($this->description01);
    }

    public function setDescription01(?string $value): static
    {
        $this->description01 = RemoveXss($value);
        return $this;
    }

    public function getDescription02(): ?string
    {
        return HtmlDecode($this->description02);
    }

    public function setDescription02(?string $value): static
    {
        $this->description02 = RemoveXss($value);
        return $this;
    }

    public function getDescription03(): ?string
    {
        return HtmlDecode($this->description03);
    }

    public function setDescription03(?string $value): static
    {
        $this->description03 = RemoveXss($value);
        return $this;
    }

    public function getDescription04(): ?string
    {
        return HtmlDecode($this->description04);
    }

    public function setDescription04(?string $value): static
    {
        $this->description04 = RemoveXss($value);
        return $this;
    }

    public function getDescription05(): ?string
    {
        return HtmlDecode($this->description05);
    }

    public function setDescription05(?string $value): static
    {
        $this->description05 = RemoveXss($value);
        return $this;
    }

    public function getDescription06(): ?string
    {
        return HtmlDecode($this->description06);
    }

    public function setDescription06(?string $value): static
    {
        $this->description06 = RemoveXss($value);
        return $this;
    }

    public function getDescription07(): ?string
    {
        return HtmlDecode($this->description07);
    }

    public function setDescription07(?string $value): static
    {
        $this->description07 = RemoveXss($value);
        return $this;
    }

    public function getDescription08(): ?string
    {
        return HtmlDecode($this->description08);
    }

    public function setDescription08(?string $value): static
    {
        $this->description08 = RemoveXss($value);
        return $this;
    }

    public function getDescription09(): ?string
    {
        return HtmlDecode($this->description09);
    }

    public function setDescription09(?string $value): static
    {
        $this->description09 = RemoveXss($value);
        return $this;
    }

    public function getDescription10(): ?string
    {
        return HtmlDecode($this->description10);
    }

    public function setDescription10(?string $value): static
    {
        $this->description10 = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }
}
