<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "rental_cart" table
 */
#[Entity]
#[Table(name: "rental_cart")]
class RentalCart extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "rid_tmp", type: "string", nullable: true)]
    private ?string $ridTmp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "quantity_sub", type: "integer")]
    private int $quantitySub;

    #[Column(type: "decimal", nullable: true)]
    private ?string $qty;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "receiving_remarks", type: "string", nullable: true)]
    private ?string $receivingRemarks;

    #[Column(type: "decimal", nullable: true)]
    private ?string $price;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "d_operator", type: "smallint", nullable: true)]
    private ?int $dOperator;

    #[Column(name: "d_datetime", type: "datetime", nullable: true)]
    private ?DateTime $dDatetime;

    #[Column(name: "r_operator", type: "smallint", nullable: true)]
    private ?int $rOperator;

    #[Column(name: "r_datetime", type: "datetime", nullable: true)]
    private ?DateTime $rDatetime;

    #[Column(name: "po_id", type: "smallint", nullable: true)]
    private ?int $poId;

    public function __construct()
    {
        $this->companyId = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID()));
        $this->sGrp = (isset($_GET["P"]))?$_GET["P"]:'';
        $this->product = (isset($_GET["Prod"]))?$_GET["Prod"]:'';
        $this->packingType = 301;
        $this->qty = (isset($_COOKIE["QTY"]))? $_COOKIE["QTY"]:'';
        $this->remarks = 'NA';
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRidTmp(): ?string
    {
        return HtmlDecode($this->ridTmp);
    }

    public function setRidTmp(?string $value): static
    {
        $this->ridTmp = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getQuantitySub(): int
    {
        return $this->quantitySub;
    }

    public function setQuantitySub(int $value): static
    {
        $this->quantitySub = $value;
        return $this;
    }

    public function getQty(): ?string
    {
        return $this->qty;
    }

    public function setQty(?string $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getReceivingRemarks(): ?string
    {
        return HtmlDecode($this->receivingRemarks);
    }

    public function setReceivingRemarks(?string $value): static
    {
        $this->receivingRemarks = RemoveXss($value);
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getDOperator(): ?int
    {
        return $this->dOperator;
    }

    public function setDOperator(?int $value): static
    {
        $this->dOperator = $value;
        return $this;
    }

    public function getDDatetime(): ?DateTime
    {
        return $this->dDatetime;
    }

    public function setDDatetime(?DateTime $value): static
    {
        $this->dDatetime = $value;
        return $this;
    }

    public function getROperator(): ?int
    {
        return $this->rOperator;
    }

    public function setROperator(?int $value): static
    {
        $this->rOperator = $value;
        return $this;
    }

    public function getRDatetime(): ?DateTime
    {
        return $this->rDatetime;
    }

    public function setRDatetime(?DateTime $value): static
    {
        $this->rDatetime = $value;
        return $this;
    }

    public function getPoId(): ?int
    {
        return $this->poId;
    }

    public function setPoId(?int $value): static
    {
        $this->poId = $value;
        return $this;
    }
}
