<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "refresh_update" table
 */
#[Entity]
#[Table(name: "refresh_update")]
class RefreshUpdate extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(name: "material_required_weekly_table", type: "datetime")]
    private DateTime $materialRequiredWeeklyTable;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMaterialRequiredWeeklyTable(): DateTime
    {
        return $this->materialRequiredWeeklyTable;
    }

    public function setMaterialRequiredWeeklyTable(DateTime $value): static
    {
        $this->materialRequiredWeeklyTable = $value;
        return $this;
    }
}
