<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "refer_to_friend" table
 */
#[Entity]
#[Table(name: "refer_to_friend")]
class ReferToFriend extends AbstractEntity
{
    #[Column(type: "smallint")]
    private int $id;

    #[Column(type: "smallint")]
    private int $userid;

    #[Column(type: "string")]
    private string $url;

    #[Column(name: "friend_email", type: "string")]
    private string $friendEmail;

    #[Column(name: "product_code", type: "integer")]
    private int $productCode;

    #[Column(type: "integer")]
    private int $type;

    #[Column(type: "string")]
    private string $comments;

    #[Column(name: "mail_status", type: "integer")]
    private int $mailStatus;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "product_url", type: "text")]
    private string $productUrl;

    public function __construct()
    {
        $this->id = 0;
        $this->mailStatus = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUserid(): int
    {
        return $this->userid;
    }

    public function setUserid(int $value): static
    {
        $this->userid = $value;
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getFriendEmail(): string
    {
        return HtmlDecode($this->friendEmail);
    }

    public function setFriendEmail(string $value): static
    {
        $this->friendEmail = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): int
    {
        return $this->productCode;
    }

    public function setProductCode(int $value): static
    {
        $this->productCode = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getComments(): string
    {
        return HtmlDecode($this->comments);
    }

    public function setComments(string $value): static
    {
        $this->comments = RemoveXss($value);
        return $this;
    }

    public function getMailStatus(): int
    {
        return $this->mailStatus;
    }

    public function setMailStatus(int $value): static
    {
        $this->mailStatus = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getProductUrl(): string
    {
        return HtmlDecode($this->productUrl);
    }

    public function setProductUrl(string $value): static
    {
        $this->productUrl = RemoveXss($value);
        return $this;
    }
}
