<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "ref_image" table
 */
#[Entity]
#[Table(name: "ref_image")]
class RefImage extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "main_image", type: "string", nullable: true)]
    private ?string $mainImage;

    #[Column(name: "top_view", type: "string", nullable: true)]
    private ?string $topView;

    #[Column(name: "front_view", type: "string", nullable: true)]
    private ?string $frontView;

    #[Column(name: "corner_view", type: "string", nullable: true)]
    private ?string $cornerView;

    #[Column(name: "back_view", type: "string", nullable: true)]
    private ?string $backView;

    #[Column(name: "color_options", type: "string", nullable: true)]
    private ?string $colorOptions;

    #[Column(name: "other_options", type: "string", nullable: true)]
    private ?string $otherOptions;

    #[Column(name: "video_url", type: "string", nullable: true)]
    private ?string $videoUrl;

    #[Column(name: "group_image", type: "string", nullable: true)]
    private ?string $groupImage;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "company_id", type: "string", nullable: true)]
    private ?string $companyId;

    #[Column(name: "product_type", type: "string", nullable: true)]
    private ?string $productType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->status = 1;
        $this->companyId = User_Company_ID();
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getMainImage(): ?string
    {
        return HtmlDecode($this->mainImage);
    }

    public function setMainImage(?string $value): static
    {
        $this->mainImage = RemoveXss($value);
        return $this;
    }

    public function getTopView(): ?string
    {
        return HtmlDecode($this->topView);
    }

    public function setTopView(?string $value): static
    {
        $this->topView = RemoveXss($value);
        return $this;
    }

    public function getFrontView(): ?string
    {
        return HtmlDecode($this->frontView);
    }

    public function setFrontView(?string $value): static
    {
        $this->frontView = RemoveXss($value);
        return $this;
    }

    public function getCornerView(): ?string
    {
        return HtmlDecode($this->cornerView);
    }

    public function setCornerView(?string $value): static
    {
        $this->cornerView = RemoveXss($value);
        return $this;
    }

    public function getBackView(): ?string
    {
        return HtmlDecode($this->backView);
    }

    public function setBackView(?string $value): static
    {
        $this->backView = RemoveXss($value);
        return $this;
    }

    public function getColorOptions(): ?string
    {
        return HtmlDecode($this->colorOptions);
    }

    public function setColorOptions(?string $value): static
    {
        $this->colorOptions = RemoveXss($value);
        return $this;
    }

    public function getOtherOptions(): ?string
    {
        return HtmlDecode($this->otherOptions);
    }

    public function setOtherOptions(?string $value): static
    {
        $this->otherOptions = RemoveXss($value);
        return $this;
    }

    public function getVideoUrl(): ?string
    {
        return HtmlDecode($this->videoUrl);
    }

    public function setVideoUrl(?string $value): static
    {
        $this->videoUrl = RemoveXss($value);
        return $this;
    }

    public function getGroupImage(): ?string
    {
        return HtmlDecode($this->groupImage);
    }

    public function setGroupImage(?string $value): static
    {
        $this->groupImage = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getCompanyId(): ?string
    {
        return HtmlDecode($this->companyId);
    }

    public function setCompanyId(?string $value): static
    {
        $this->companyId = RemoveXss($value);
        return $this;
    }

    public function getProductType(): ?string
    {
        return HtmlDecode($this->productType);
    }

    public function setProductType(?string $value): static
    {
        $this->productType = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
