<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "ref_code" table
 */
#[Entity]
#[Table(name: "ref_code")]
class RefCode extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_type", type: "string", nullable: true)]
    private ?string $productType;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "product_code_type", type: "integer")]
    private int $productCodeType;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "v_00", type: "string", nullable: true)]
    private ?string $v00;

    #[Column(name: "v_01", type: "string", nullable: true)]
    private ?string $v01;

    #[Column(name: "v_02", type: "string", nullable: true)]
    private ?string $v02;

    #[Column(name: "v_03", type: "string", nullable: true)]
    private ?string $v03;

    #[Column(name: "v_04", type: "string", nullable: true)]
    private ?string $v04;

    #[Column(name: "v_05", type: "string", nullable: true)]
    private ?string $v05;

    #[Column(name: "v_06", type: "string", nullable: true)]
    private ?string $v06;

    #[Column(name: "v_07", type: "string", nullable: true)]
    private ?string $v07;

    #[Column(name: "v_08", type: "string", nullable: true)]
    private ?string $v08;

    #[Column(name: "v_09", type: "string", nullable: true)]
    private ?string $v09;

    #[Column(name: "v_10", type: "string", nullable: true)]
    private ?string $v10;

    #[Column(name: "last_price", type: "string", nullable: true)]
    private ?string $lastPrice;

    #[Column(type: "smallint")]
    private int $currency;

    #[Column(type: "smallint", nullable: true)]
    private ?int $composition;

    #[Column(type: "decimal", nullable: true)]
    private ?string $moq;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->productType = "0";
        $this->packingType = 0;
        $this->productCodeType = 0;
        $this->currency = 1;
        $this->moq = "0.000";
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductType(): ?string
    {
        return HtmlDecode($this->productType);
    }

    public function setProductType(?string $value): static
    {
        $this->productType = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getProductCodeType(): int
    {
        return $this->productCodeType;
    }

    public function setProductCodeType(int $value): static
    {
        $this->productCodeType = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getV00(): ?string
    {
        return HtmlDecode($this->v00);
    }

    public function setV00(?string $value): static
    {
        $this->v00 = RemoveXss($value);
        return $this;
    }

    public function getV01(): ?string
    {
        return HtmlDecode($this->v01);
    }

    public function setV01(?string $value): static
    {
        $this->v01 = RemoveXss($value);
        return $this;
    }

    public function getV02(): ?string
    {
        return HtmlDecode($this->v02);
    }

    public function setV02(?string $value): static
    {
        $this->v02 = RemoveXss($value);
        return $this;
    }

    public function getV03(): ?string
    {
        return HtmlDecode($this->v03);
    }

    public function setV03(?string $value): static
    {
        $this->v03 = RemoveXss($value);
        return $this;
    }

    public function getV04(): ?string
    {
        return HtmlDecode($this->v04);
    }

    public function setV04(?string $value): static
    {
        $this->v04 = RemoveXss($value);
        return $this;
    }

    public function getV05(): ?string
    {
        return HtmlDecode($this->v05);
    }

    public function setV05(?string $value): static
    {
        $this->v05 = RemoveXss($value);
        return $this;
    }

    public function getV06(): ?string
    {
        return HtmlDecode($this->v06);
    }

    public function setV06(?string $value): static
    {
        $this->v06 = RemoveXss($value);
        return $this;
    }

    public function getV07(): ?string
    {
        return HtmlDecode($this->v07);
    }

    public function setV07(?string $value): static
    {
        $this->v07 = RemoveXss($value);
        return $this;
    }

    public function getV08(): ?string
    {
        return HtmlDecode($this->v08);
    }

    public function setV08(?string $value): static
    {
        $this->v08 = RemoveXss($value);
        return $this;
    }

    public function getV09(): ?string
    {
        return HtmlDecode($this->v09);
    }

    public function setV09(?string $value): static
    {
        $this->v09 = RemoveXss($value);
        return $this;
    }

    public function getV10(): ?string
    {
        return HtmlDecode($this->v10);
    }

    public function setV10(?string $value): static
    {
        $this->v10 = RemoveXss($value);
        return $this;
    }

    public function getLastPrice(): ?string
    {
        return HtmlDecode($this->lastPrice);
    }

    public function setLastPrice(?string $value): static
    {
        $this->lastPrice = RemoveXss($value);
        return $this;
    }

    public function getCurrency(): int
    {
        return $this->currency;
    }

    public function setCurrency(int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getComposition(): ?int
    {
        return $this->composition;
    }

    public function setComposition(?int $value): static
    {
        $this->composition = $value;
        return $this;
    }

    public function getMoq(): ?string
    {
        return $this->moq;
    }

    public function setMoq(?string $value): static
    {
        $this->moq = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
