<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "ref" table
 */
#[Entity]
#[Table(name: "ref")]
class Ref extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $oid;

    #[Column(name: "company_id", type: "string", nullable: true)]
    private ?string $companyId;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_type", type: "string", nullable: true)]
    private ?string $productType;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "product_n", type: "string", nullable: true)]
    private ?string $productN;

    #[Column(type: "string", nullable: true)]
    private ?string $barcode;

    #[Column(name: "product_code_type", type: "integer")]
    private int $productCodeType;

    #[Column(name: "product_code", type: "string", unique: true, nullable: true)]
    private ?string $productCode;

    #[Column(name: "print_name", type: "string", nullable: true)]
    private ?string $printName;

    #[Column(type: "string", nullable: true)]
    private ?string $gcode;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(name: "product_id", type: "string", nullable: true)]
    private ?string $productId;

    #[Column(name: "batch_no", type: "string", nullable: true)]
    private ?string $batchNo;

    #[Column(name: "set_ref", type: "string", nullable: true)]
    private ?string $setRef;

    #[Column(name: "v_00", type: "string", nullable: true)]
    private ?string $v00;

    #[Column(name: "v_01", type: "string", nullable: true)]
    private ?string $v01;

    #[Column(name: "v_02", type: "string", nullable: true)]
    private ?string $v02;

    #[Column(name: "v_03", type: "string", nullable: true)]
    private ?string $v03;

    #[Column(name: "v_04", type: "string", nullable: true)]
    private ?string $v04;

    #[Column(name: "v_05", type: "string", nullable: true)]
    private ?string $v05;

    #[Column(name: "v_06", type: "string", nullable: true)]
    private ?string $v06;

    #[Column(name: "v_07", type: "string", nullable: true)]
    private ?string $v07;

    #[Column(name: "v_08", type: "string", nullable: true)]
    private ?string $v08;

    #[Column(name: "v_09", type: "string", nullable: true)]
    private ?string $v09;

    #[Column(name: "v_10", type: "string", nullable: true)]
    private ?string $v10;

    #[Column(type: "float", nullable: true)]
    private ?float $cbm;

    #[Column(type: "float", nullable: true)]
    private ?float $sqm;

    #[Column(type: "string", nullable: true)]
    private ?string $shape;

    #[Column(name: "q_sku", type: "decimal")]
    private string $qSku;

    #[Column(name: "b_01", type: "string", nullable: true)]
    private ?string $b01;

    #[Column(name: "b_02", type: "string", nullable: true)]
    private ?string $b02;

    #[Column(name: "b_03", type: "string", nullable: true)]
    private ?string $b03;

    #[Column(name: "b_04", type: "string", nullable: true)]
    private ?string $b04;

    #[Column(name: "b_05", type: "string", nullable: true)]
    private ?string $b05;

    #[Column(name: "b_06", type: "string", nullable: true)]
    private ?string $b06;

    #[Column(name: "b_07", type: "string", nullable: true)]
    private ?string $b07;

    #[Column(name: "b_08", type: "string", nullable: true)]
    private ?string $b08;

    #[Column(name: "b_09", type: "string", nullable: true)]
    private ?string $b09;

    #[Column(name: "b_10", type: "string", nullable: true)]
    private ?string $b10;

    #[Column(name: "b_11", type: "string", nullable: true)]
    private ?string $b11;

    #[Column(name: "b_12", type: "string", nullable: true)]
    private ?string $b12;

    #[Column(name: "b_13", type: "string", nullable: true)]
    private ?string $b13;

    #[Column(name: "b_14", type: "string", nullable: true)]
    private ?string $b14;

    #[Column(name: "b_15", type: "string", nullable: true)]
    private ?string $b15;

    #[Column(name: "t_01", type: "string", nullable: true)]
    private ?string $t01;

    #[Column(name: "t_02", type: "string", nullable: true)]
    private ?string $t02;

    #[Column(name: "t_03", type: "string", nullable: true)]
    private ?string $t03;

    #[Column(name: "t_04", type: "string", nullable: true)]
    private ?string $t04;

    #[Column(name: "t_05", type: "string", nullable: true)]
    private ?string $t05;

    #[Column(name: "t_06", type: "string", nullable: true)]
    private ?string $t06;

    #[Column(name: "t_07", type: "string", nullable: true)]
    private ?string $t07;

    #[Column(name: "t_08", type: "string", nullable: true)]
    private ?string $t08;

    #[Column(name: "t_09", type: "string", nullable: true)]
    private ?string $t09;

    #[Column(name: "t_10", type: "string", nullable: true)]
    private ?string $t10;

    #[Column(name: "t_11", type: "string", nullable: true)]
    private ?string $t11;

    #[Column(name: "t_12", type: "string", nullable: true)]
    private ?string $t12;

    #[Column(name: "t_13", type: "string", nullable: true)]
    private ?string $t13;

    #[Column(name: "t_14", type: "string", nullable: true)]
    private ?string $t14;

    #[Column(name: "t_15", type: "string", nullable: true)]
    private ?string $t15;

    #[Column(name: "last_price", type: "string", nullable: true)]
    private ?string $lastPrice;

    #[Column(type: "smallint")]
    private int $currency;

    #[Column(type: "integer", nullable: true)]
    private ?int $hsn;

    #[Column(type: "smallint", nullable: true)]
    private ?int $composition;

    #[Column(type: "smallint", nullable: true)]
    private ?int $category;

    #[Column(type: "decimal", nullable: true)]
    private ?string $moq;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "d_head_01", type: "string", nullable: true)]
    private ?string $dHead01;

    #[Column(name: "d_description_01", type: "text", nullable: true)]
    private ?string $dDescription01;

    #[Column(name: "d_head_02", type: "string", nullable: true)]
    private ?string $dHead02;

    #[Column(name: "d_description_02", type: "text", nullable: true)]
    private ?string $dDescription02;

    #[Column(type: "smallint", nullable: true)]
    private ?int $publish;

    #[Column(type: "string", nullable: true)]
    private ?string $keywords;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "main_image", type: "string", nullable: true)]
    private ?string $mainImage;

    #[Column(name: "top_view", type: "string", nullable: true)]
    private ?string $topView;

    #[Column(name: "front_view", type: "string", nullable: true)]
    private ?string $frontView;

    #[Column(name: "corner_view", type: "string", nullable: true)]
    private ?string $cornerView;

    #[Column(name: "back_view", type: "string", nullable: true)]
    private ?string $backView;

    #[Column(name: "color_options", type: "string", nullable: true)]
    private ?string $colorOptions;

    #[Column(name: "other_options", type: "string", nullable: true)]
    private ?string $otherOptions;

    #[Column(name: "group_image", type: "string", nullable: true)]
    private ?string $groupImage;

    #[Column(name: "video_url", type: "string", nullable: true)]
    private ?string $videoUrl;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "`in`", options: ["name" => "in"], type: "decimal")]
    private string $in;

    #[Column(name: "`out`", options: ["name" => "out"], type: "decimal")]
    private string $out;

    #[Column(type: "decimal")]
    private string $required;

    #[Column(type: "decimal")]
    private string $blocked;

    #[Column(type: "decimal")]
    private string $ordered;

    #[Column(type: "smallint", nullable: true)]
    private ?int $supplier;

    #[Column(type: "smallint", nullable: true)]
    private ?int $country;

    #[Column(name: "minimum_stock", type: "decimal")]
    private string $minimumStock;

    public function __construct()
    {
        $this->companyId = User_Company_ID();
        $this->productType = "0";
        $this->packingType = 0;
        $this->productCodeType = 0;
        $this->qSku = "1.00";
        $this->currency = 1;
        $this->moq = "0.000";
        $this->status = 1;
        $this->publish = 0;
        $this->operator = 0;
        $this->minimumStock = "0.000";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getOid(): ?string
    {
        return HtmlDecode($this->oid);
    }

    public function setOid(?string $value): static
    {
        $this->oid = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): ?string
    {
        return HtmlDecode($this->companyId);
    }

    public function setCompanyId(?string $value): static
    {
        $this->companyId = RemoveXss($value);
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductType(): ?string
    {
        return HtmlDecode($this->productType);
    }

    public function setProductType(?string $value): static
    {
        $this->productType = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getProductN(): ?string
    {
        return HtmlDecode($this->productN);
    }

    public function setProductN(?string $value): static
    {
        $this->productN = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getProductCodeType(): int
    {
        return $this->productCodeType;
    }

    public function setProductCodeType(int $value): static
    {
        $this->productCodeType = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPrintName(): ?string
    {
        return HtmlDecode($this->printName);
    }

    public function setPrintName(?string $value): static
    {
        $this->printName = RemoveXss($value);
        return $this;
    }

    public function getGcode(): ?string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(?string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getProductId(): ?string
    {
        return HtmlDecode($this->productId);
    }

    public function setProductId(?string $value): static
    {
        $this->productId = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?string
    {
        return HtmlDecode($this->batchNo);
    }

    public function setBatchNo(?string $value): static
    {
        $this->batchNo = RemoveXss($value);
        return $this;
    }

    public function getSetRef(): ?string
    {
        return HtmlDecode($this->setRef);
    }

    public function setSetRef(?string $value): static
    {
        $this->setRef = RemoveXss($value);
        return $this;
    }

    public function getV00(): ?string
    {
        return HtmlDecode($this->v00);
    }

    public function setV00(?string $value): static
    {
        $this->v00 = RemoveXss($value);
        return $this;
    }

    public function getV01(): ?string
    {
        return HtmlDecode($this->v01);
    }

    public function setV01(?string $value): static
    {
        $this->v01 = RemoveXss($value);
        return $this;
    }

    public function getV02(): ?string
    {
        return HtmlDecode($this->v02);
    }

    public function setV02(?string $value): static
    {
        $this->v02 = RemoveXss($value);
        return $this;
    }

    public function getV03(): ?string
    {
        return HtmlDecode($this->v03);
    }

    public function setV03(?string $value): static
    {
        $this->v03 = RemoveXss($value);
        return $this;
    }

    public function getV04(): ?string
    {
        return HtmlDecode($this->v04);
    }

    public function setV04(?string $value): static
    {
        $this->v04 = RemoveXss($value);
        return $this;
    }

    public function getV05(): ?string
    {
        return HtmlDecode($this->v05);
    }

    public function setV05(?string $value): static
    {
        $this->v05 = RemoveXss($value);
        return $this;
    }

    public function getV06(): ?string
    {
        return HtmlDecode($this->v06);
    }

    public function setV06(?string $value): static
    {
        $this->v06 = RemoveXss($value);
        return $this;
    }

    public function getV07(): ?string
    {
        return HtmlDecode($this->v07);
    }

    public function setV07(?string $value): static
    {
        $this->v07 = RemoveXss($value);
        return $this;
    }

    public function getV08(): ?string
    {
        return HtmlDecode($this->v08);
    }

    public function setV08(?string $value): static
    {
        $this->v08 = RemoveXss($value);
        return $this;
    }

    public function getV09(): ?string
    {
        return HtmlDecode($this->v09);
    }

    public function setV09(?string $value): static
    {
        $this->v09 = RemoveXss($value);
        return $this;
    }

    public function getV10(): ?string
    {
        return HtmlDecode($this->v10);
    }

    public function setV10(?string $value): static
    {
        $this->v10 = RemoveXss($value);
        return $this;
    }

    public function getCbm(): ?float
    {
        return $this->cbm;
    }

    public function setCbm(?float $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getSqm(): ?float
    {
        return $this->sqm;
    }

    public function setSqm(?float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getShape(): ?string
    {
        return HtmlDecode($this->shape);
    }

    public function setShape(?string $value): static
    {
        $this->shape = RemoveXss($value);
        return $this;
    }

    public function getQSku(): string
    {
        return $this->qSku;
    }

    public function setQSku(string $value): static
    {
        $this->qSku = $value;
        return $this;
    }

    public function getB01(): ?string
    {
        return HtmlDecode($this->b01);
    }

    public function setB01(?string $value): static
    {
        $this->b01 = RemoveXss($value);
        return $this;
    }

    public function getB02(): ?string
    {
        return HtmlDecode($this->b02);
    }

    public function setB02(?string $value): static
    {
        $this->b02 = RemoveXss($value);
        return $this;
    }

    public function getB03(): ?string
    {
        return HtmlDecode($this->b03);
    }

    public function setB03(?string $value): static
    {
        $this->b03 = RemoveXss($value);
        return $this;
    }

    public function getB04(): ?string
    {
        return HtmlDecode($this->b04);
    }

    public function setB04(?string $value): static
    {
        $this->b04 = RemoveXss($value);
        return $this;
    }

    public function getB05(): ?string
    {
        return HtmlDecode($this->b05);
    }

    public function setB05(?string $value): static
    {
        $this->b05 = RemoveXss($value);
        return $this;
    }

    public function getB06(): ?string
    {
        return HtmlDecode($this->b06);
    }

    public function setB06(?string $value): static
    {
        $this->b06 = RemoveXss($value);
        return $this;
    }

    public function getB07(): ?string
    {
        return HtmlDecode($this->b07);
    }

    public function setB07(?string $value): static
    {
        $this->b07 = RemoveXss($value);
        return $this;
    }

    public function getB08(): ?string
    {
        return HtmlDecode($this->b08);
    }

    public function setB08(?string $value): static
    {
        $this->b08 = RemoveXss($value);
        return $this;
    }

    public function getB09(): ?string
    {
        return HtmlDecode($this->b09);
    }

    public function setB09(?string $value): static
    {
        $this->b09 = RemoveXss($value);
        return $this;
    }

    public function getB10(): ?string
    {
        return HtmlDecode($this->b10);
    }

    public function setB10(?string $value): static
    {
        $this->b10 = RemoveXss($value);
        return $this;
    }

    public function getB11(): ?string
    {
        return HtmlDecode($this->b11);
    }

    public function setB11(?string $value): static
    {
        $this->b11 = RemoveXss($value);
        return $this;
    }

    public function getB12(): ?string
    {
        return HtmlDecode($this->b12);
    }

    public function setB12(?string $value): static
    {
        $this->b12 = RemoveXss($value);
        return $this;
    }

    public function getB13(): ?string
    {
        return HtmlDecode($this->b13);
    }

    public function setB13(?string $value): static
    {
        $this->b13 = RemoveXss($value);
        return $this;
    }

    public function getB14(): ?string
    {
        return HtmlDecode($this->b14);
    }

    public function setB14(?string $value): static
    {
        $this->b14 = RemoveXss($value);
        return $this;
    }

    public function getB15(): ?string
    {
        return HtmlDecode($this->b15);
    }

    public function setB15(?string $value): static
    {
        $this->b15 = RemoveXss($value);
        return $this;
    }

    public function getT01(): ?string
    {
        return HtmlDecode($this->t01);
    }

    public function setT01(?string $value): static
    {
        $this->t01 = RemoveXss($value);
        return $this;
    }

    public function getT02(): ?string
    {
        return HtmlDecode($this->t02);
    }

    public function setT02(?string $value): static
    {
        $this->t02 = RemoveXss($value);
        return $this;
    }

    public function getT03(): ?string
    {
        return HtmlDecode($this->t03);
    }

    public function setT03(?string $value): static
    {
        $this->t03 = RemoveXss($value);
        return $this;
    }

    public function getT04(): ?string
    {
        return HtmlDecode($this->t04);
    }

    public function setT04(?string $value): static
    {
        $this->t04 = RemoveXss($value);
        return $this;
    }

    public function getT05(): ?string
    {
        return HtmlDecode($this->t05);
    }

    public function setT05(?string $value): static
    {
        $this->t05 = RemoveXss($value);
        return $this;
    }

    public function getT06(): ?string
    {
        return HtmlDecode($this->t06);
    }

    public function setT06(?string $value): static
    {
        $this->t06 = RemoveXss($value);
        return $this;
    }

    public function getT07(): ?string
    {
        return HtmlDecode($this->t07);
    }

    public function setT07(?string $value): static
    {
        $this->t07 = RemoveXss($value);
        return $this;
    }

    public function getT08(): ?string
    {
        return HtmlDecode($this->t08);
    }

    public function setT08(?string $value): static
    {
        $this->t08 = RemoveXss($value);
        return $this;
    }

    public function getT09(): ?string
    {
        return HtmlDecode($this->t09);
    }

    public function setT09(?string $value): static
    {
        $this->t09 = RemoveXss($value);
        return $this;
    }

    public function getT10(): ?string
    {
        return HtmlDecode($this->t10);
    }

    public function setT10(?string $value): static
    {
        $this->t10 = RemoveXss($value);
        return $this;
    }

    public function getT11(): ?string
    {
        return HtmlDecode($this->t11);
    }

    public function setT11(?string $value): static
    {
        $this->t11 = RemoveXss($value);
        return $this;
    }

    public function getT12(): ?string
    {
        return HtmlDecode($this->t12);
    }

    public function setT12(?string $value): static
    {
        $this->t12 = RemoveXss($value);
        return $this;
    }

    public function getT13(): ?string
    {
        return HtmlDecode($this->t13);
    }

    public function setT13(?string $value): static
    {
        $this->t13 = RemoveXss($value);
        return $this;
    }

    public function getT14(): ?string
    {
        return HtmlDecode($this->t14);
    }

    public function setT14(?string $value): static
    {
        $this->t14 = RemoveXss($value);
        return $this;
    }

    public function getT15(): ?string
    {
        return HtmlDecode($this->t15);
    }

    public function setT15(?string $value): static
    {
        $this->t15 = RemoveXss($value);
        return $this;
    }

    public function getLastPrice(): ?string
    {
        return HtmlDecode($this->lastPrice);
    }

    public function setLastPrice(?string $value): static
    {
        $this->lastPrice = RemoveXss($value);
        return $this;
    }

    public function getCurrency(): int
    {
        return $this->currency;
    }

    public function setCurrency(int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getHsn(): ?int
    {
        return $this->hsn;
    }

    public function setHsn(?int $value): static
    {
        $this->hsn = $value;
        return $this;
    }

    public function getComposition(): ?int
    {
        return $this->composition;
    }

    public function setComposition(?int $value): static
    {
        $this->composition = $value;
        return $this;
    }

    public function getCategory(): ?int
    {
        return $this->category;
    }

    public function setCategory(?int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getMoq(): ?string
    {
        return $this->moq;
    }

    public function setMoq(?string $value): static
    {
        $this->moq = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getDHead01(): ?string
    {
        return HtmlDecode($this->dHead01);
    }

    public function setDHead01(?string $value): static
    {
        $this->dHead01 = RemoveXss($value);
        return $this;
    }

    public function getDDescription01(): ?string
    {
        return HtmlDecode($this->dDescription01);
    }

    public function setDDescription01(?string $value): static
    {
        $this->dDescription01 = RemoveXss($value);
        return $this;
    }

    public function getDHead02(): ?string
    {
        return HtmlDecode($this->dHead02);
    }

    public function setDHead02(?string $value): static
    {
        $this->dHead02 = RemoveXss($value);
        return $this;
    }

    public function getDDescription02(): ?string
    {
        return HtmlDecode($this->dDescription02);
    }

    public function setDDescription02(?string $value): static
    {
        $this->dDescription02 = RemoveXss($value);
        return $this;
    }

    public function getPublish(): ?int
    {
        return $this->publish;
    }

    public function setPublish(?int $value): static
    {
        $this->publish = $value;
        return $this;
    }

    public function getKeywords(): ?string
    {
        return HtmlDecode($this->keywords);
    }

    public function setKeywords(?string $value): static
    {
        $this->keywords = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getMainImage(): ?string
    {
        return HtmlDecode($this->mainImage);
    }

    public function setMainImage(?string $value): static
    {
        $this->mainImage = RemoveXss($value);
        return $this;
    }

    public function getTopView(): ?string
    {
        return HtmlDecode($this->topView);
    }

    public function setTopView(?string $value): static
    {
        $this->topView = RemoveXss($value);
        return $this;
    }

    public function getFrontView(): ?string
    {
        return HtmlDecode($this->frontView);
    }

    public function setFrontView(?string $value): static
    {
        $this->frontView = RemoveXss($value);
        return $this;
    }

    public function getCornerView(): ?string
    {
        return HtmlDecode($this->cornerView);
    }

    public function setCornerView(?string $value): static
    {
        $this->cornerView = RemoveXss($value);
        return $this;
    }

    public function getBackView(): ?string
    {
        return HtmlDecode($this->backView);
    }

    public function setBackView(?string $value): static
    {
        $this->backView = RemoveXss($value);
        return $this;
    }

    public function getColorOptions(): ?string
    {
        return HtmlDecode($this->colorOptions);
    }

    public function setColorOptions(?string $value): static
    {
        $this->colorOptions = RemoveXss($value);
        return $this;
    }

    public function getOtherOptions(): ?string
    {
        return HtmlDecode($this->otherOptions);
    }

    public function setOtherOptions(?string $value): static
    {
        $this->otherOptions = RemoveXss($value);
        return $this;
    }

    public function getGroupImage(): ?string
    {
        return HtmlDecode($this->groupImage);
    }

    public function setGroupImage(?string $value): static
    {
        $this->groupImage = RemoveXss($value);
        return $this;
    }

    public function getVideoUrl(): ?string
    {
        return HtmlDecode($this->videoUrl);
    }

    public function setVideoUrl(?string $value): static
    {
        $this->videoUrl = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getIn(): string
    {
        return $this->in;
    }

    public function setIn(string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): string
    {
        return $this->out;
    }

    public function setOut(string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getRequired(): string
    {
        return $this->required;
    }

    public function setRequired(string $value): static
    {
        $this->required = $value;
        return $this;
    }

    public function getBlocked(): string
    {
        return $this->blocked;
    }

    public function setBlocked(string $value): static
    {
        $this->blocked = $value;
        return $this;
    }

    public function getOrdered(): string
    {
        return $this->ordered;
    }

    public function setOrdered(string $value): static
    {
        $this->ordered = $value;
        return $this;
    }

    public function getSupplier(): ?int
    {
        return $this->supplier;
    }

    public function setSupplier(?int $value): static
    {
        $this->supplier = $value;
        return $this;
    }

    public function getCountry(): ?int
    {
        return $this->country;
    }

    public function setCountry(?int $value): static
    {
        $this->country = $value;
        return $this;
    }

    public function getMinimumStock(): string
    {
        return $this->minimumStock;
    }

    public function setMinimumStock(string $value): static
    {
        $this->minimumStock = $value;
        return $this;
    }
}
