<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "receipt_b" table
 */
#[Entity]
#[Table(name: "receipt_b")]
class ReceiptB extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $location;

    #[Column(name: "from_account", type: "integer", nullable: true)]
    private ?int $fromAccount;

    #[Column(name: "to_account", type: "integer", nullable: true)]
    private ?int $toAccount;

    #[Column(type: "string", nullable: true)]
    private ?string $reference;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->location = (isset($_GET["loc"]))? $_GET["loc"]:User_Site();
        $this->fromAccount = (isset($_GET["f"]))? $_GET["f"]:'';
        $this->toAccount = (isset($_GET["t"]))? $_GET["t"]:'';
        $this->reference = (isset($_GET["r"]))? $_GET["r"]:'';
        $this->amount = (isset($_GET["a"]))? $_GET["a"]:'';
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getFromAccount(): ?int
    {
        return $this->fromAccount;
    }

    public function setFromAccount(?int $value): static
    {
        $this->fromAccount = $value;
        return $this;
    }

    public function getToAccount(): ?int
    {
        return $this->toAccount;
    }

    public function setToAccount(?int $value): static
    {
        $this->toAccount = $value;
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
