<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "receipt" table
 */
#[Entity]
#[Table(name: "receipt")]
class Receipt extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $location;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "from_account", type: "integer", nullable: true)]
    private ?int $fromAccount;

    #[Column(type: "string", nullable: true)]
    private ?string $reference;

    #[Column(name: "total_amount", type: "decimal", nullable: true)]
    private ?string $totalAmount;

    #[Column(name: "panel_pending", type: "decimal", nullable: true)]
    private ?string $panelPending;

    #[Column(name: "panel_amount", type: "decimal", nullable: true)]
    private ?string $panelAmount;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(name: "to_account", type: "integer", nullable: true)]
    private ?int $toAccount;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->location = (isset($_GET['location'])) ? $_GET['location'] : '';
        $this->fromAccount = (isset($_GET['partner'])) ? $_GET['partner'] : '';
        $this->reference = (isset($_GET['oid']))  ? $_GET['oid'] : '';
        $this->totalAmount = (isset($_GET['balance']))  ? $_GET['balance'] : '';
        $this->panelPending = "0";
        $this->panelAmount = "0";
        $this->amount = (isset($_GET['balance']))  ? $_GET['balance'] : '';
        $this->balance = "0";
        $this->toAccount = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getFromAccount(): ?int
    {
        return $this->fromAccount;
    }

    public function setFromAccount(?int $value): static
    {
        $this->fromAccount = $value;
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $value): static
    {
        $this->totalAmount = $value;
        return $this;
    }

    public function getPanelPending(): ?string
    {
        return $this->panelPending;
    }

    public function setPanelPending(?string $value): static
    {
        $this->panelPending = $value;
        return $this;
    }

    public function getPanelAmount(): ?string
    {
        return $this->panelAmount;
    }

    public function setPanelAmount(?string $value): static
    {
        $this->panelAmount = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getToAccount(): ?int
    {
        return $this->toAccount;
    }

    public function setToAccount(?int $value): static
    {
        $this->toAccount = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
