<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "quotation" table
 */
#[Entity]
#[Table(name: "quotation")]
class Quotation extends AbstractEntity
{
    #[Column(type: "smallint")]
    private int $id;

    #[Column(name: "main_image", type: "string", nullable: true)]
    private ?string $mainImage;

    #[Column(name: "godown_id", type: "decimal", nullable: true)]
    private ?string $godownId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "Balance", type: "string", nullable: true)]
    private ?string $balance;

    #[Column(type: "decimal", nullable: true)]
    private ?string $price;

    #[Column(name: "price_kg", type: "float", nullable: true)]
    private ?float $priceKg;

    #[Column(name: "price_unit", type: "float", nullable: true)]
    private ?float $priceUnit;

    #[Column(name: "b_12", type: "string", nullable: true)]
    private ?string $b12;

    #[Column(name: "b_01", type: "string", nullable: true)]
    private ?string $b01;

    #[Column(name: "v_01", type: "string", nullable: true)]
    private ?string $v01;

    #[Column(name: "v_02", type: "string", nullable: true)]
    private ?string $v02;

    #[Column(name: "v_03", type: "string", nullable: true)]
    private ?string $v03;

    #[Column(name: "v_04", type: "string", nullable: true)]
    private ?string $v04;

    #[Column(name: "v_05", type: "string", nullable: true)]
    private ?string $v05;

    #[Column(name: "Amount", type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(name: "packing_type", type: "decimal", nullable: true)]
    private ?string $packingType;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMainImage(): ?string
    {
        return HtmlDecode($this->mainImage);
    }

    public function setMainImage(?string $value): static
    {
        $this->mainImage = RemoveXss($value);
        return $this;
    }

    public function getGodownId(): ?string
    {
        return $this->godownId;
    }

    public function setGodownId(?string $value): static
    {
        $this->godownId = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getBalance(): ?string
    {
        return HtmlDecode($this->balance);
    }

    public function setBalance(?string $value): static
    {
        $this->balance = RemoveXss($value);
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getPriceKg(): ?float
    {
        return $this->priceKg;
    }

    public function setPriceKg(?float $value): static
    {
        $this->priceKg = $value;
        return $this;
    }

    public function getPriceUnit(): ?float
    {
        return $this->priceUnit;
    }

    public function setPriceUnit(?float $value): static
    {
        $this->priceUnit = $value;
        return $this;
    }

    public function getB12(): ?string
    {
        return HtmlDecode($this->b12);
    }

    public function setB12(?string $value): static
    {
        $this->b12 = RemoveXss($value);
        return $this;
    }

    public function getB01(): ?string
    {
        return HtmlDecode($this->b01);
    }

    public function setB01(?string $value): static
    {
        $this->b01 = RemoveXss($value);
        return $this;
    }

    public function getV01(): ?string
    {
        return HtmlDecode($this->v01);
    }

    public function setV01(?string $value): static
    {
        $this->v01 = RemoveXss($value);
        return $this;
    }

    public function getV02(): ?string
    {
        return HtmlDecode($this->v02);
    }

    public function setV02(?string $value): static
    {
        $this->v02 = RemoveXss($value);
        return $this;
    }

    public function getV03(): ?string
    {
        return HtmlDecode($this->v03);
    }

    public function setV03(?string $value): static
    {
        $this->v03 = RemoveXss($value);
        return $this;
    }

    public function getV04(): ?string
    {
        return HtmlDecode($this->v04);
    }

    public function setV04(?string $value): static
    {
        $this->v04 = RemoveXss($value);
        return $this;
    }

    public function getV05(): ?string
    {
        return HtmlDecode($this->v05);
    }

    public function setV05(?string $value): static
    {
        $this->v05 = RemoveXss($value);
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getPackingType(): ?string
    {
        return $this->packingType;
    }

    public function setPackingType(?string $value): static
    {
        $this->packingType = $value;
        return $this;
    }
}
