<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "query_production_table" table
 */
#[Entity]
#[Table(name: "query_production_table")]
class QueryProductionTable extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $buyer;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(name: "buyer_ref", type: "string", nullable: true)]
    private ?string $buyerRef;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_cm", type: "string", nullable: true)]
    private ?string $sizeCm;

    #[Column(name: "Weaving", type: "string", nullable: true)]
    private ?string $weaving;

    #[Column(name: "Packing", type: "string", nullable: true)]
    private ?string $packing;

    #[Column(name: "order_quantity", type: "smallint", nullable: true)]
    private ?int $orderQuantity;

    #[Column(type: "smallint", nullable: true)]
    private ?int $count;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(name: "sqm_a", type: "decimal", nullable: true)]
    private ?string $sqmA;

    #[Column(name: "process_c", type: "string", nullable: true)]
    private ?string $processC;

    #[Column(name: "process_d", type: "string", nullable: true)]
    private ?string $processD;

    #[Column(type: "text", nullable: true)]
    private ?string $barcode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(name: "dispatch_week_p", type: "smallint")]
    private int $dispatchWeekP;

    #[Column(name: "current_works", type: "smallint", nullable: true)]
    private ?int $currentWorks;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "buyer_barcode", type: "string", nullable: true)]
    private ?string $buyerBarcode;

    public function __construct()
    {
        $this->count = 0;
        $this->barcode = "0";
        $this->currentWorks = 0;
    }

    public function getBuyer(): ?int
    {
        return $this->buyer;
    }

    public function setBuyer(?int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBuyerRef(): ?string
    {
        return HtmlDecode($this->buyerRef);
    }

    public function setBuyerRef(?string $value): static
    {
        $this->buyerRef = RemoveXss($value);
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): ?string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(?string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getWeaving(): ?string
    {
        return HtmlDecode($this->weaving);
    }

    public function setWeaving(?string $value): static
    {
        $this->weaving = RemoveXss($value);
        return $this;
    }

    public function getPacking(): ?string
    {
        return HtmlDecode($this->packing);
    }

    public function setPacking(?string $value): static
    {
        $this->packing = RemoveXss($value);
        return $this;
    }

    public function getOrderQuantity(): ?int
    {
        return $this->orderQuantity;
    }

    public function setOrderQuantity(?int $value): static
    {
        $this->orderQuantity = $value;
        return $this;
    }

    public function getCount(): ?int
    {
        return $this->count;
    }

    public function setCount(?int $value): static
    {
        $this->count = $value;
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmA(): ?string
    {
        return $this->sqmA;
    }

    public function setSqmA(?string $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function getProcessC(): ?string
    {
        return HtmlDecode($this->processC);
    }

    public function setProcessC(?string $value): static
    {
        $this->processC = RemoveXss($value);
        return $this;
    }

    public function getProcessD(): ?string
    {
        return HtmlDecode($this->processD);
    }

    public function setProcessD(?string $value): static
    {
        $this->processD = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getDispatchWeekP(): int
    {
        return $this->dispatchWeekP;
    }

    public function setDispatchWeekP(int $value): static
    {
        $this->dispatchWeekP = $value;
        return $this;
    }

    public function getCurrentWorks(): ?int
    {
        return $this->currentWorks;
    }

    public function setCurrentWorks(?int $value): static
    {
        $this->currentWorks = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyerBarcode(): ?string
    {
        return HtmlDecode($this->buyerBarcode);
    }

    public function setBuyerBarcode(?string $value): static
    {
        $this->buyerBarcode = RemoveXss($value);
        return $this;
    }
}
