<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "query_pppo_pending" table
 */
#[Entity]
#[Table(name: "query_pppo_pending")]
class QueryPppoPending extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "`Order`", options: ["name" => "Order"], type: "bigint")]
    private string $order;

    #[Column(name: "Received", type: "bigint")]
    private string $received;

    #[Column(name: "Pending", type: "bigint")]
    private string $pending;

    #[Column(name: "`Received BC`", options: ["name" => "Received BC"], type: "text")]
    private string $receivedBc;

    #[Column(name: "`Pending BC`", options: ["name" => "Pending BC"], type: "text")]
    private string $pendingBc;

    #[Column(name: "size_buyer", type: "string", nullable: true)]
    private ?string $sizeBuyer;

    #[Column(name: "buyer_ref", type: "string", nullable: true)]
    private ?string $buyerRef;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(name: "pp_id", type: "integer", nullable: true)]
    private ?int $ppId;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    public function __construct()
    {
        $this->order = "0";
        $this->received = "0";
        $this->pending = "0";
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getOrder(): string
    {
        return $this->order;
    }

    public function setOrder(string $value): static
    {
        $this->order = $value;
        return $this;
    }

    public function getReceived(): string
    {
        return $this->received;
    }

    public function setReceived(string $value): static
    {
        $this->received = $value;
        return $this;
    }

    public function getPending(): string
    {
        return $this->pending;
    }

    public function setPending(string $value): static
    {
        $this->pending = $value;
        return $this;
    }

    public function getReceivedBc(): string
    {
        return HtmlDecode($this->receivedBc);
    }

    public function setReceivedBc(string $value): static
    {
        $this->receivedBc = RemoveXss($value);
        return $this;
    }

    public function getPendingBc(): string
    {
        return HtmlDecode($this->pendingBc);
    }

    public function setPendingBc(string $value): static
    {
        $this->pendingBc = RemoveXss($value);
        return $this;
    }

    public function getSizeBuyer(): ?string
    {
        return HtmlDecode($this->sizeBuyer);
    }

    public function setSizeBuyer(?string $value): static
    {
        $this->sizeBuyer = RemoveXss($value);
        return $this;
    }

    public function getBuyerRef(): ?string
    {
        return HtmlDecode($this->buyerRef);
    }

    public function setBuyerRef(?string $value): static
    {
        $this->buyerRef = RemoveXss($value);
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getPpId(): ?int
    {
        return $this->ppId;
    }

    public function setPpId(?int $value): static
    {
        $this->ppId = $value;
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }
}
