<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "query_oms" table
 */
#[Entity]
#[Table(name: "query_oms")]
class QueryOm extends AbstractEntity
{
    #[Id]
    #[Column(type: "bigint", nullable: true)]
    private ?string $id;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(name: "order_week", type: "smallint", nullable: true)]
    private ?int $orderWeek;

    #[Column(name: "order_date", type: "date", nullable: true)]
    private ?DateTime $orderDate;

    #[Column(name: "buyer_order", type: "text", nullable: true)]
    private ?string $buyerOrder;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(type: "string", nullable: true)]
    private ?string $item;

    #[Column(name: "buyer_ref", type: "string", nullable: true)]
    private ?string $buyerRef;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(name: "size_buyer", type: "string", nullable: true)]
    private ?string $sizeBuyer;

    #[Column(type: "smallint", nullable: true)]
    private ?int $width;

    #[Column(type: "smallint", nullable: true)]
    private ?int $length;

    #[Column(type: "smallint", nullable: true)]
    private ?int $qty;

    #[Column(name: "revised_qty", type: "bigint", nullable: true)]
    private ?string $revisedQty;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(name: "ex_factory", type: "smallint", nullable: true)]
    private ?int $exFactory;

    #[Column(name: "ex_factory_p", type: "text", nullable: true)]
    private ?string $exFactoryP;

    #[Column(name: "shipping_mode", type: "string", nullable: true)]
    private ?string $shippingMode;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "d_qty", type: "decimal", nullable: true)]
    private ?string $dQty;

    #[Column(name: "pl_no", type: "text", nullable: true)]
    private ?string $plNo;

    #[Column(name: "invoice_date", type: "string")]
    private string $invoiceDate;

    #[Column(name: "sailing_week", type: "string")]
    private string $sailingWeek;

    #[Column(type: "decimal", nullable: true)]
    private ?string $pending;

    #[Column(name: "pending_sqm", type: "decimal", nullable: true)]
    private ?string $pendingSqm;

    #[Column(type: "string")]
    private string $cbm;

    #[Column(name: "total_cbm", type: "string")]
    private string $totalCbm;

    #[Column(type: "decimal", nullable: true)]
    private ?string $offloom;

    #[Column(type: "text", nullable: true)]
    private ?string $status;

    #[Column(type: "integer")]
    private int $rejection;

    #[Column(type: "text", nullable: true)]
    private ?string $completed;

    #[Column(name: "reports_to", type: "string", nullable: true)]
    private ?string $reportsTo;

    #[Column(name: "weight_sqm", type: "decimal", nullable: true)]
    private ?string $weightSqm;

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(?string $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getOrderWeek(): ?int
    {
        return $this->orderWeek;
    }

    public function setOrderWeek(?int $value): static
    {
        $this->orderWeek = $value;
        return $this;
    }

    public function getOrderDate(): ?DateTime
    {
        return $this->orderDate;
    }

    public function setOrderDate(?DateTime $value): static
    {
        $this->orderDate = $value;
        return $this;
    }

    public function getBuyerOrder(): ?string
    {
        return HtmlDecode($this->buyerOrder);
    }

    public function setBuyerOrder(?string $value): static
    {
        $this->buyerOrder = RemoveXss($value);
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getItem(): ?string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(?string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getBuyerRef(): ?string
    {
        return HtmlDecode($this->buyerRef);
    }

    public function setBuyerRef(?string $value): static
    {
        $this->buyerRef = RemoveXss($value);
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getSizeBuyer(): ?string
    {
        return HtmlDecode($this->sizeBuyer);
    }

    public function setSizeBuyer(?string $value): static
    {
        $this->sizeBuyer = RemoveXss($value);
        return $this;
    }

    public function getWidth(): ?int
    {
        return $this->width;
    }

    public function setWidth(?int $value): static
    {
        $this->width = $value;
        return $this;
    }

    public function getLength(): ?int
    {
        return $this->length;
    }

    public function setLength(?int $value): static
    {
        $this->length = $value;
        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getRevisedQty(): ?string
    {
        return $this->revisedQty;
    }

    public function setRevisedQty(?string $value): static
    {
        $this->revisedQty = $value;
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getExFactory(): ?int
    {
        return $this->exFactory;
    }

    public function setExFactory(?int $value): static
    {
        $this->exFactory = $value;
        return $this;
    }

    public function getExFactoryP(): ?string
    {
        return HtmlDecode($this->exFactoryP);
    }

    public function setExFactoryP(?string $value): static
    {
        $this->exFactoryP = RemoveXss($value);
        return $this;
    }

    public function getShippingMode(): ?string
    {
        return HtmlDecode($this->shippingMode);
    }

    public function setShippingMode(?string $value): static
    {
        $this->shippingMode = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getDQty(): ?string
    {
        return $this->dQty;
    }

    public function setDQty(?string $value): static
    {
        $this->dQty = $value;
        return $this;
    }

    public function getPlNo(): ?string
    {
        return HtmlDecode($this->plNo);
    }

    public function setPlNo(?string $value): static
    {
        $this->plNo = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDate(): string
    {
        return HtmlDecode($this->invoiceDate);
    }

    public function setInvoiceDate(string $value): static
    {
        $this->invoiceDate = RemoveXss($value);
        return $this;
    }

    public function getSailingWeek(): string
    {
        return HtmlDecode($this->sailingWeek);
    }

    public function setSailingWeek(string $value): static
    {
        $this->sailingWeek = RemoveXss($value);
        return $this;
    }

    public function getPending(): ?string
    {
        return $this->pending;
    }

    public function setPending(?string $value): static
    {
        $this->pending = $value;
        return $this;
    }

    public function getPendingSqm(): ?string
    {
        return $this->pendingSqm;
    }

    public function setPendingSqm(?string $value): static
    {
        $this->pendingSqm = $value;
        return $this;
    }

    public function getCbm(): string
    {
        return HtmlDecode($this->cbm);
    }

    public function setCbm(string $value): static
    {
        $this->cbm = RemoveXss($value);
        return $this;
    }

    public function getTotalCbm(): string
    {
        return HtmlDecode($this->totalCbm);
    }

    public function setTotalCbm(string $value): static
    {
        $this->totalCbm = RemoveXss($value);
        return $this;
    }

    public function getOffloom(): ?string
    {
        return $this->offloom;
    }

    public function setOffloom(?string $value): static
    {
        $this->offloom = $value;
        return $this;
    }

    public function getStatus(): ?string
    {
        return HtmlDecode($this->status);
    }

    public function setStatus(?string $value): static
    {
        $this->status = RemoveXss($value);
        return $this;
    }

    public function getRejection(): int
    {
        return $this->rejection;
    }

    public function setRejection(int $value): static
    {
        $this->rejection = $value;
        return $this;
    }

    public function getCompleted(): ?string
    {
        return HtmlDecode($this->completed);
    }

    public function setCompleted(?string $value): static
    {
        $this->completed = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): ?string
    {
        return HtmlDecode($this->reportsTo);
    }

    public function setReportsTo(?string $value): static
    {
        $this->reportsTo = RemoveXss($value);
        return $this;
    }

    public function getWeightSqm(): ?string
    {
        return $this->weightSqm;
    }

    public function setWeightSqm(?string $value): static
    {
        $this->weightSqm = $value;
        return $this;
    }
}
