<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "qc_missing" table
 */
#[Entity]
#[Table(name: "qc_missing")]
class QcMissing extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $barcode;

    #[Column(name: "pending_days", type: "integer", nullable: true)]
    private ?int $pendingDays;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(name: "pl_no", type: "decimal")]
    private string $plNo;

    #[Column(name: "process_datetime", type: "datetime", nullable: true)]
    private ?DateTime $processDatetime;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(name: "process_c", type: "string", nullable: true)]
    private ?string $processC;

    public function __construct()
    {
        $this->barcode = 0;
        $this->plNo = "0.00";
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getPendingDays(): ?int
    {
        return $this->pendingDays;
    }

    public function setPendingDays(?int $value): static
    {
        $this->pendingDays = $value;
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getPlNo(): string
    {
        return $this->plNo;
    }

    public function setPlNo(string $value): static
    {
        $this->plNo = $value;
        return $this;
    }

    public function getProcessDatetime(): ?DateTime
    {
        return $this->processDatetime;
    }

    public function setProcessDatetime(?DateTime $value): static
    {
        $this->processDatetime = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getProcessC(): ?string
    {
        return HtmlDecode($this->processC);
    }

    public function setProcessC(?string $value): static
    {
        $this->processC = RemoveXss($value);
        return $this;
    }
}
