<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "qc_authorised" table
 */
#[Entity]
#[Table(name: "qc_authorised")]
class QcAuthorised extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(type: "integer")]
    private int $barcode;

    #[Column(name: "defect_nature", type: "string")]
    private string $defectNature;

    #[Column(name: "qc_stage", type: "integer")]
    private int $qcStage;

    #[Column(name: "defect_percentage", type: "integer", nullable: true)]
    private ?int $defectPercentage;

    #[Column(type: "smallint", nullable: true)]
    private ?int $deduction;

    #[Column(type: "string", nullable: true)]
    private ?string $comments;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(type: "string", nullable: true)]
    private ?string $size;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(type: "integer", nullable: true)]
    private ?int $action;

    #[Column(name: "bcode_status", type: "smallint", nullable: true)]
    private ?int $bcodeStatus;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    public function __construct()
    {
        $this->location = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
        $this->defectNature = "30";
        $this->defectPercentage = 0;
        $this->deduction = 0;
        $this->status = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getDefectNature(): string
    {
        return HtmlDecode($this->defectNature);
    }

    public function setDefectNature(string $value): static
    {
        $this->defectNature = RemoveXss($value);
        return $this;
    }

    public function getQcStage(): int
    {
        return $this->qcStage;
    }

    public function setQcStage(int $value): static
    {
        $this->qcStage = $value;
        return $this;
    }

    public function getDefectPercentage(): ?int
    {
        return $this->defectPercentage;
    }

    public function setDefectPercentage(?int $value): static
    {
        $this->defectPercentage = $value;
        return $this;
    }

    public function getDeduction(): ?int
    {
        return $this->deduction;
    }

    public function setDeduction(?int $value): static
    {
        $this->deduction = $value;
        return $this;
    }

    public function getComments(): ?string
    {
        return HtmlDecode($this->comments);
    }

    public function setComments(?string $value): static
    {
        $this->comments = RemoveXss($value);
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getSize(): ?string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(?string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getAction(): ?int
    {
        return $this->action;
    }

    public function setAction(?int $value): static
    {
        $this->action = $value;
        return $this;
    }

    public function getBcodeStatus(): ?int
    {
        return $this->bcodeStatus;
    }

    public function setBcodeStatus(?int $value): static
    {
        $this->bcodeStatus = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }
}
