<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "purchase_l_qc" table
 */
#[Entity]
#[Table(name: "purchase_l_qc")]
class PurchaseLQc extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(type: "string", nullable: true)]
    private ?string $po;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "net_weight", type: "decimal", nullable: true)]
    private ?string $netWeight;

    #[Column(name: "qc_status", type: "smallint", nullable: true)]
    private ?int $qcStatus;

    #[Column(name: "qc_remarks", type: "string", nullable: true)]
    private ?string $qcRemarks;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(name: "`@`", options: ["name" => "@"], type: "decimal", nullable: true)]
    private ?string $40;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(type: "string", nullable: true)]
    private ?string $rack;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "goods_inward", type: "string", nullable: true)]
    private ?string $goodsInward;

    #[Column(name: "invoice_details", type: "string")]
    private string $invoiceDetails;

    #[Column(name: "invoice_dated", type: "date", nullable: true)]
    private ?DateTime $invoiceDated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer")]
    private int $audit;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "smallint", nullable: true)]
    private ?int $aDatetime;

    #[Column(name: "qc_operator", type: "smallint", nullable: true)]
    private ?int $qcOperator;

    #[Column(name: "qc_datetime", type: "datetime", nullable: true)]
    private ?DateTime $qcDatetime;

    public function __construct()
    {
        $this->type = 72;
        $this->rid = ((isset($_GET["rid"]))? $_GET["rid"]:'');
        $this->lotNo = 'NA';
        $this->netWeight = "0";
        $this->packets = "0";
        $this->packingType = (isset($_COOKIE["pk"]))? $_COOKIE["pk"]:'';
        $this->rack = "0";
        $this->invoiceDetails = (isset($_COOKIE["ino"]))? $_COOKIE["ino"]:'';
        $this->operator = 0;
        $this->audit = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getPo(): ?string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(?string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getNetWeight(): ?string
    {
        return $this->netWeight;
    }

    public function setNetWeight(?string $value): static
    {
        $this->netWeight = $value;
        return $this;
    }

    public function getQcStatus(): ?int
    {
        return $this->qcStatus;
    }

    public function setQcStatus(?int $value): static
    {
        $this->qcStatus = $value;
        return $this;
    }

    public function getQcRemarks(): ?string
    {
        return HtmlDecode($this->qcRemarks);
    }

    public function setQcRemarks(?string $value): static
    {
        $this->qcRemarks = RemoveXss($value);
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function get40(): ?string
    {
        return $this->40;
    }

    public function set40(?string $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getRack(): ?string
    {
        return HtmlDecode($this->rack);
    }

    public function setRack(?string $value): static
    {
        $this->rack = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getGoodsInward(): ?string
    {
        return HtmlDecode($this->goodsInward);
    }

    public function setGoodsInward(?string $value): static
    {
        $this->goodsInward = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDetails(): string
    {
        return HtmlDecode($this->invoiceDetails);
    }

    public function setInvoiceDetails(string $value): static
    {
        $this->invoiceDetails = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDated(): ?DateTime
    {
        return $this->invoiceDated;
    }

    public function setInvoiceDated(?DateTime $value): static
    {
        $this->invoiceDated = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getAudit(): int
    {
        return $this->audit;
    }

    public function setAudit(int $value): static
    {
        $this->audit = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?int
    {
        return $this->aDatetime;
    }

    public function setADatetime(?int $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getQcOperator(): ?int
    {
        return $this->qcOperator;
    }

    public function setQcOperator(?int $value): static
    {
        $this->qcOperator = $value;
        return $this;
    }

    public function getQcDatetime(): ?DateTime
    {
        return $this->qcDatetime;
    }

    public function setQcDatetime(?DateTime $value): static
    {
        $this->qcDatetime = $value;
        return $this;
    }
}
