<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "purchase_l_bc" table
 */
#[Entity]
#[Table(name: "purchase_l_bc")]
class PurchaseLBc extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $supplier;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "net_weight", type: "decimal", nullable: true)]
    private ?string $netWeight;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(type: "string", nullable: true)]
    private ?string $rack;

    #[Column(type: "integer", nullable: true)]
    private ?int $barcode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->supplier = ((isset($_COOKIE["Supplier"]))? $_COOKIE["Supplier"]:'');
        $this->godown = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
        $this->netWeight = "1";
        $this->packets = "1";
        $this->packingType = ((isset($_COOKIE["Packing"]))? $_COOKIE["Packing"]:'');
        $this->rack = ((isset($_COOKIE["Rack"]))? $_COOKIE["Rack"]:'');
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSupplier(): ?int
    {
        return $this->supplier;
    }

    public function setSupplier(?int $value): static
    {
        $this->supplier = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getNetWeight(): ?string
    {
        return $this->netWeight;
    }

    public function setNetWeight(?string $value): static
    {
        $this->netWeight = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getRack(): ?string
    {
        return HtmlDecode($this->rack);
    }

    public function setRack(?string $value): static
    {
        $this->rack = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?int
    {
        return $this->barcode;
    }

    public function setBarcode(?int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
