<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "purchase_l" table
 */
#[Entity]
#[Table(name: "purchase_l")]
class PurchaseL extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(type: "integer", nullable: true)]
    private ?int $supplier;

    #[Column(type: "string", nullable: true)]
    private ?string $po;

    #[Column(name: "po_return", type: "integer", nullable: true)]
    private ?int $poReturn;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(name: "rid_return", type: "string", nullable: true)]
    private ?string $ridReturn;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "avg_quantity", type: "smallint", nullable: true)]
    private ?int $avgQuantity;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "net_weight", type: "decimal", nullable: true)]
    private ?string $netWeight;

    #[Column(name: "`@`", options: ["name" => "@"], type: "decimal", nullable: true)]
    private ?string $40;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "string", nullable: true)]
    private ?string $rack;

    #[Column(type: "integer")]
    private int $updated;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "goods_inward", type: "string", nullable: true)]
    private ?string $goodsInward;

    #[Column(name: "invoice_details", type: "string")]
    private string $invoiceDetails;

    #[Column(name: "invoice_dated", type: "date", nullable: true)]
    private ?DateTime $invoiceDated;

    #[Column(type: "integer", nullable: true)]
    private ?int $barcode;

    #[Column(type: "integer", nullable: true)]
    private ?int $country;

    #[Column(name: "wool_type", type: "integer", nullable: true)]
    private ?int $woolType;

    #[Column(type: "integer", nullable: true)]
    private ?int $quality;

    #[Column(name: "sorting_type", type: "smallint", nullable: true)]
    private ?int $sortingType;

    #[Column(name: "scouring_type", type: "smallint", nullable: true)]
    private ?int $scouringType;

    #[Column(name: "dye_type", type: "smallint", nullable: true)]
    private ?int $dyeType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $importer;

    #[Column(type: "integer", nullable: true)]
    private ?int $grade;

    #[Column(name: "return_details", type: "string", nullable: true)]
    private ?string $returnDetails;

    #[Column(type: "integer")]
    private int $audit;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "smallint", nullable: true)]
    private ?int $aDatetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $agent;

    #[Column(name: "qc_remarks", type: "string", nullable: true)]
    private ?string $qcRemarks;

    #[Column(name: "qc_status", type: "smallint", nullable: true)]
    private ?int $qcStatus;

    #[Column(name: "qc_operator", type: "smallint", nullable: true)]
    private ?int $qcOperator;

    #[Column(name: "qc_datetime", type: "datetime", nullable: true)]
    private ?DateTime $qcDatetime;

    #[Column(type: "smallint")]
    private int $age;

    public function __construct()
    {
        $this->type = 72;
        $this->supplier = ((isset($_GET["sup"])) ? $_GET["sup"] : ((isset($_COOKIE["sup"]))? $_COOKIE["sup"]:''));
        $this->grp = ((isset($_GET["grp"])) ? $_GET["grp"] : ((isset($_COOKIE["grp"]))? $_COOKIE["grp"]:''));
        $this->sGrp = ((isset($_GET["s_grp"])) ? $_GET["s_grp"] : ((isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:''));
        $this->product = ((isset($_GET["product"])) ? $_GET["product"] : ((isset($_COOKIE["product"]))? $_COOKIE["product"]:''));
        $this->rid = ((isset($_GET["rid"]))? $_GET["rid"]:'');
        $this->packingType = (isset($_COOKIE["pk"]))? $_COOKIE["pk"]:'';
        $this->lotNo = 'NA';
        $this->avgQuantity = 0.00;
        $this->packets = "0";
        $this->netWeight = "0";
        $this->operator = 0;
        $this->rack = "0";
        $this->updated = 0;
        $this->invoiceDetails = (isset($_COOKIE["ino"]))? $_COOKIE["ino"]:'';
        $this->country = 1;
        $this->woolType = 1;
        $this->quality = 1;
        $this->sortingType = 1;
        $this->scouringType = 1;
        $this->dyeType = 1;
        $this->importer = 1;
        $this->grade = 1;
        $this->audit = 0;
        $this->age = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getSupplier(): ?int
    {
        return $this->supplier;
    }

    public function setSupplier(?int $value): static
    {
        $this->supplier = $value;
        return $this;
    }

    public function getPo(): ?string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(?string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }

    public function getPoReturn(): ?int
    {
        return $this->poReturn;
    }

    public function setPoReturn(?int $value): static
    {
        $this->poReturn = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRidReturn(): ?string
    {
        return HtmlDecode($this->ridReturn);
    }

    public function setRidReturn(?string $value): static
    {
        $this->ridReturn = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getAvgQuantity(): ?int
    {
        return $this->avgQuantity;
    }

    public function setAvgQuantity(?int $value): static
    {
        $this->avgQuantity = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getNetWeight(): ?string
    {
        return $this->netWeight;
    }

    public function setNetWeight(?string $value): static
    {
        $this->netWeight = $value;
        return $this;
    }

    public function get40(): ?string
    {
        return $this->40;
    }

    public function set40(?string $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getRack(): ?string
    {
        return HtmlDecode($this->rack);
    }

    public function setRack(?string $value): static
    {
        $this->rack = RemoveXss($value);
        return $this;
    }

    public function getUpdated(): int
    {
        return $this->updated;
    }

    public function setUpdated(int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getGoodsInward(): ?string
    {
        return HtmlDecode($this->goodsInward);
    }

    public function setGoodsInward(?string $value): static
    {
        $this->goodsInward = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDetails(): string
    {
        return HtmlDecode($this->invoiceDetails);
    }

    public function setInvoiceDetails(string $value): static
    {
        $this->invoiceDetails = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDated(): ?DateTime
    {
        return $this->invoiceDated;
    }

    public function setInvoiceDated(?DateTime $value): static
    {
        $this->invoiceDated = $value;
        return $this;
    }

    public function getBarcode(): ?int
    {
        return $this->barcode;
    }

    public function setBarcode(?int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getCountry(): ?int
    {
        return $this->country;
    }

    public function setCountry(?int $value): static
    {
        $this->country = $value;
        return $this;
    }

    public function getWoolType(): ?int
    {
        return $this->woolType;
    }

    public function setWoolType(?int $value): static
    {
        $this->woolType = $value;
        return $this;
    }

    public function getQuality(): ?int
    {
        return $this->quality;
    }

    public function setQuality(?int $value): static
    {
        $this->quality = $value;
        return $this;
    }

    public function getSortingType(): ?int
    {
        return $this->sortingType;
    }

    public function setSortingType(?int $value): static
    {
        $this->sortingType = $value;
        return $this;
    }

    public function getScouringType(): ?int
    {
        return $this->scouringType;
    }

    public function setScouringType(?int $value): static
    {
        $this->scouringType = $value;
        return $this;
    }

    public function getDyeType(): ?int
    {
        return $this->dyeType;
    }

    public function setDyeType(?int $value): static
    {
        $this->dyeType = $value;
        return $this;
    }

    public function getImporter(): ?int
    {
        return $this->importer;
    }

    public function setImporter(?int $value): static
    {
        $this->importer = $value;
        return $this;
    }

    public function getGrade(): ?int
    {
        return $this->grade;
    }

    public function setGrade(?int $value): static
    {
        $this->grade = $value;
        return $this;
    }

    public function getReturnDetails(): ?string
    {
        return HtmlDecode($this->returnDetails);
    }

    public function setReturnDetails(?string $value): static
    {
        $this->returnDetails = RemoveXss($value);
        return $this;
    }

    public function getAudit(): int
    {
        return $this->audit;
    }

    public function setAudit(int $value): static
    {
        $this->audit = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?int
    {
        return $this->aDatetime;
    }

    public function setADatetime(?int $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getAgent(): ?int
    {
        return $this->agent;
    }

    public function setAgent(?int $value): static
    {
        $this->agent = $value;
        return $this;
    }

    public function getQcRemarks(): ?string
    {
        return HtmlDecode($this->qcRemarks);
    }

    public function setQcRemarks(?string $value): static
    {
        $this->qcRemarks = RemoveXss($value);
        return $this;
    }

    public function getQcStatus(): ?int
    {
        return $this->qcStatus;
    }

    public function setQcStatus(?int $value): static
    {
        $this->qcStatus = $value;
        return $this;
    }

    public function getQcOperator(): ?int
    {
        return $this->qcOperator;
    }

    public function setQcOperator(?int $value): static
    {
        $this->qcOperator = $value;
        return $this;
    }

    public function getQcDatetime(): ?DateTime
    {
        return $this->qcDatetime;
    }

    public function setQcDatetime(?DateTime $value): static
    {
        $this->qcDatetime = $value;
        return $this;
    }

    public function getAge(): int
    {
        return $this->age;
    }

    public function setAge(int $value): static
    {
        $this->age = $value;
        return $this;
    }
}
