<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "purchase_a_old" table
 */
#[Entity]
#[Table(name: "purchase_a_old")]
class PurchaseAOld extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(type: "integer")]
    private int $supplier;

    #[Column(name: "booking_reference", type: "smallint")]
    private int $bookingReference;

    #[Column(name: "lot_no", type: "string")]
    private string $lotNo;

    #[Column(name: "port_arrival_date", type: "datetime", nullable: true)]
    private ?DateTime $portArrivalDate;

    #[Column(name: "godown_arrival_date", type: "datetime", nullable: true)]
    private ?DateTime $godownArrivalDate;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(type: "string")]
    private string $rack;

    #[Column(name: "gross_weight", type: "decimal", nullable: true)]
    private ?string $grossWeight;

    #[Column(name: "net_weight", type: "decimal")]
    private string $netWeight;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(name: "packing_type", type: "integer")]
    private int $packingType;

    #[Column(type: "decimal")]
    private string $containers;

    #[Column(name: "invoice_details", type: "string", nullable: true)]
    private ?string $invoiceDetails;

    #[Column(name: "invoice_value", type: "decimal", nullable: true)]
    private ?string $invoiceValue;

    #[Column(name: "rbi_compliance_date", type: "date", nullable: true)]
    private ?DateTime $rbiComplianceDate;

    #[Column(name: "currency_rate", type: "decimal", nullable: true)]
    private ?string $currencyRate;

    #[Column(name: "shipping_line", type: "integer", nullable: true)]
    private ?int $shippingLine;

    #[Column(name: "cha_agent", type: "integer", nullable: true)]
    private ?int $chaAgent;

    #[Column(name: "clearance_bank", type: "integer", nullable: true)]
    private ?int $clearanceBank;

    #[Column(name: "bank_charges", type: "decimal", nullable: true)]
    private ?string $bankCharges;

    #[Column(name: "purchase_amount_inr", type: "decimal", nullable: true)]
    private ?string $purchaseAmountInr;

    #[Column(name: "custom_duty", type: "decimal", nullable: true)]
    private ?string $customDuty;

    #[Column(name: "duty_paid_by", type: "integer", nullable: true)]
    private ?int $dutyPaidBy;

    #[Column(name: "port_clearing_charge", type: "decimal", nullable: true)]
    private ?string $portClearingCharge;

    #[Column(name: "transportation_charges", type: "decimal", nullable: true)]
    private ?string $transportationCharges;

    #[Column(name: "cha_commission", type: "decimal", nullable: true)]
    private ?string $chaCommission;

    #[Column(type: "integer", nullable: true)]
    private ?int $importer;

    #[Column(name: "fiba_fibd", type: "string")]
    private string $fibaFibd;

    #[Column(type: "string")]
    private string $fibc;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer")]
    private int $updated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "qc_remarks", type: "string", nullable: true)]
    private ?string $qcRemarks;

    #[Column(name: "qc_status", type: "smallint", nullable: true)]
    private ?int $qcStatus;

    #[Column(name: "qc_operator", type: "smallint", nullable: true)]
    private ?int $qcOperator;

    #[Column(name: "qc_datetime", type: "datetime", nullable: true)]
    private ?DateTime $qcDatetime;

    #[Column(type: "smallint")]
    private int $age;

    public function __construct()
    {
        $this->rack = "0";
        $this->packingType = 1;
        $this->updated = 0;
        $this->operator = 0;
        $this->age = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getSupplier(): int
    {
        return $this->supplier;
    }

    public function setSupplier(int $value): static
    {
        $this->supplier = $value;
        return $this;
    }

    public function getBookingReference(): int
    {
        return $this->bookingReference;
    }

    public function setBookingReference(int $value): static
    {
        $this->bookingReference = $value;
        return $this;
    }

    public function getLotNo(): string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getPortArrivalDate(): ?DateTime
    {
        return $this->portArrivalDate;
    }

    public function setPortArrivalDate(?DateTime $value): static
    {
        $this->portArrivalDate = $value;
        return $this;
    }

    public function getGodownArrivalDate(): ?DateTime
    {
        return $this->godownArrivalDate;
    }

    public function setGodownArrivalDate(?DateTime $value): static
    {
        $this->godownArrivalDate = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getRack(): string
    {
        return HtmlDecode($this->rack);
    }

    public function setRack(string $value): static
    {
        $this->rack = RemoveXss($value);
        return $this;
    }

    public function getGrossWeight(): ?string
    {
        return $this->grossWeight;
    }

    public function setGrossWeight(?string $value): static
    {
        $this->grossWeight = $value;
        return $this;
    }

    public function getNetWeight(): string
    {
        return $this->netWeight;
    }

    public function setNetWeight(string $value): static
    {
        $this->netWeight = $value;
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getContainers(): string
    {
        return $this->containers;
    }

    public function setContainers(string $value): static
    {
        $this->containers = $value;
        return $this;
    }

    public function getInvoiceDetails(): ?string
    {
        return HtmlDecode($this->invoiceDetails);
    }

    public function setInvoiceDetails(?string $value): static
    {
        $this->invoiceDetails = RemoveXss($value);
        return $this;
    }

    public function getInvoiceValue(): ?string
    {
        return $this->invoiceValue;
    }

    public function setInvoiceValue(?string $value): static
    {
        $this->invoiceValue = $value;
        return $this;
    }

    public function getRbiComplianceDate(): ?DateTime
    {
        return $this->rbiComplianceDate;
    }

    public function setRbiComplianceDate(?DateTime $value): static
    {
        $this->rbiComplianceDate = $value;
        return $this;
    }

    public function getCurrencyRate(): ?string
    {
        return $this->currencyRate;
    }

    public function setCurrencyRate(?string $value): static
    {
        $this->currencyRate = $value;
        return $this;
    }

    public function getShippingLine(): ?int
    {
        return $this->shippingLine;
    }

    public function setShippingLine(?int $value): static
    {
        $this->shippingLine = $value;
        return $this;
    }

    public function getChaAgent(): ?int
    {
        return $this->chaAgent;
    }

    public function setChaAgent(?int $value): static
    {
        $this->chaAgent = $value;
        return $this;
    }

    public function getClearanceBank(): ?int
    {
        return $this->clearanceBank;
    }

    public function setClearanceBank(?int $value): static
    {
        $this->clearanceBank = $value;
        return $this;
    }

    public function getBankCharges(): ?string
    {
        return $this->bankCharges;
    }

    public function setBankCharges(?string $value): static
    {
        $this->bankCharges = $value;
        return $this;
    }

    public function getPurchaseAmountInr(): ?string
    {
        return $this->purchaseAmountInr;
    }

    public function setPurchaseAmountInr(?string $value): static
    {
        $this->purchaseAmountInr = $value;
        return $this;
    }

    public function getCustomDuty(): ?string
    {
        return $this->customDuty;
    }

    public function setCustomDuty(?string $value): static
    {
        $this->customDuty = $value;
        return $this;
    }

    public function getDutyPaidBy(): ?int
    {
        return $this->dutyPaidBy;
    }

    public function setDutyPaidBy(?int $value): static
    {
        $this->dutyPaidBy = $value;
        return $this;
    }

    public function getPortClearingCharge(): ?string
    {
        return $this->portClearingCharge;
    }

    public function setPortClearingCharge(?string $value): static
    {
        $this->portClearingCharge = $value;
        return $this;
    }

    public function getTransportationCharges(): ?string
    {
        return $this->transportationCharges;
    }

    public function setTransportationCharges(?string $value): static
    {
        $this->transportationCharges = $value;
        return $this;
    }

    public function getChaCommission(): ?string
    {
        return $this->chaCommission;
    }

    public function setChaCommission(?string $value): static
    {
        $this->chaCommission = $value;
        return $this;
    }

    public function getImporter(): ?int
    {
        return $this->importer;
    }

    public function setImporter(?int $value): static
    {
        $this->importer = $value;
        return $this;
    }

    public function getFibaFibd(): string
    {
        return HtmlDecode($this->fibaFibd);
    }

    public function setFibaFibd(string $value): static
    {
        $this->fibaFibd = RemoveXss($value);
        return $this;
    }

    public function getFibc(): string
    {
        return HtmlDecode($this->fibc);
    }

    public function setFibc(string $value): static
    {
        $this->fibc = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUpdated(): int
    {
        return $this->updated;
    }

    public function setUpdated(int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getQcRemarks(): ?string
    {
        return HtmlDecode($this->qcRemarks);
    }

    public function setQcRemarks(?string $value): static
    {
        $this->qcRemarks = RemoveXss($value);
        return $this;
    }

    public function getQcStatus(): ?int
    {
        return $this->qcStatus;
    }

    public function setQcStatus(?int $value): static
    {
        $this->qcStatus = $value;
        return $this;
    }

    public function getQcOperator(): ?int
    {
        return $this->qcOperator;
    }

    public function setQcOperator(?int $value): static
    {
        $this->qcOperator = $value;
        return $this;
    }

    public function getQcDatetime(): ?DateTime
    {
        return $this->qcDatetime;
    }

    public function setQcDatetime(?DateTime $value): static
    {
        $this->qcDatetime = $value;
        return $this;
    }

    public function getAge(): int
    {
        return $this->age;
    }

    public function setAge(int $value): static
    {
        $this->age = $value;
        return $this;
    }
}
