<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "property_details" table
 */
#[Entity]
#[Table(name: "property_details")]
class PropertyDetail extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(type: "string")]
    private string $floor;

    #[Column(type: "string")]
    private string $no;

    #[Column(type: "string")]
    private string $length;

    #[Column(type: "string")]
    private string $width;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(type: "integer")]
    private int $area;

    #[Column(name: "sa_area", type: "integer")]
    private int $saArea;

    #[Column(type: "string")]
    private string $coords;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getFloor(): string
    {
        return HtmlDecode($this->floor);
    }

    public function setFloor(string $value): static
    {
        $this->floor = RemoveXss($value);
        return $this;
    }

    public function getNo(): string
    {
        return HtmlDecode($this->no);
    }

    public function setNo(string $value): static
    {
        $this->no = RemoveXss($value);
        return $this;
    }

    public function getLength(): string
    {
        return HtmlDecode($this->length);
    }

    public function setLength(string $value): static
    {
        $this->length = RemoveXss($value);
        return $this;
    }

    public function getWidth(): string
    {
        return HtmlDecode($this->width);
    }

    public function setWidth(string $value): static
    {
        $this->width = RemoveXss($value);
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getArea(): int
    {
        return $this->area;
    }

    public function setArea(int $value): static
    {
        $this->area = $value;
        return $this;
    }

    public function getSaArea(): int
    {
        return $this->saArea;
    }

    public function setSaArea(int $value): static
    {
        $this->saArea = $value;
        return $this;
    }

    public function getCoords(): string
    {
        return HtmlDecode($this->coords);
    }

    public function setCoords(string $value): static
    {
        $this->coords = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
