<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "promotional_message_text" table
 */
#[Entity]
#[Table(name: "promotional_message_text")]
class PromotionalMessageText extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(type: "integer")]
    private int $whatsapp;

    #[Column(name: "whatsapp_message", type: "text", nullable: true)]
    private ?string $whatsappMessage;

    public function __construct()
    {
        $this->whatsapp = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWhatsapp(): int
    {
        return $this->whatsapp;
    }

    public function setWhatsapp(int $value): static
    {
        $this->whatsapp = $value;
        return $this;
    }

    public function getWhatsappMessage(): ?string
    {
        return HtmlDecode($this->whatsappMessage);
    }

    public function setWhatsappMessage(?string $value): static
    {
        $this->whatsappMessage = RemoveXss($value);
        return $this;
    }
}
