<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "production_process_live" table
 */
#[Entity]
#[Table(name: "production_process_live")]
class ProductionProcessLive extends AbstractEntity
{
    #[Column(name: "batch_no", type: "decimal", nullable: true)]
    private ?string $batchNo;

    #[Column(type: "string", nullable: true)]
    private ?string $material;

    #[Column(type: "string", nullable: true)]
    private ?string $mid;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(type: "integer")]
    private int $p;

    public function __construct()
    {
        $this->p = 0;
    }

    public function getBatchNo(): ?string
    {
        return $this->batchNo;
    }

    public function setBatchNo(?string $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getMaterial(): ?string
    {
        return HtmlDecode($this->material);
    }

    public function setMaterial(?string $value): static
    {
        $this->material = RemoveXss($value);
        return $this;
    }

    public function getMid(): ?string
    {
        return HtmlDecode($this->mid);
    }

    public function setMid(?string $value): static
    {
        $this->mid = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getP(): int
    {
        return $this->p;
    }

    public function setP(int $value): static
    {
        $this->p = $value;
        return $this;
    }
}
