<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "production_process_g" table
 */
#[Entity]
#[Table(name: "production_process_g")]
class ProductionProcessG extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "string")]
    private string $rid;

    #[Column(name: "batch_no", type: "smallint")]
    private int $batchNo;

    #[Column(type: "string")]
    private string $sequence;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(name: "process_name", type: "string", nullable: true)]
    private ?string $processName;

    #[Column(type: "string")]
    private string $material;

    #[Column(name: "material_name", type: "text", nullable: true)]
    private ?string $materialName;

    #[Column(type: "decimal")]
    private string $quantity;

    #[Column(name: "m_power", type: "integer")]
    private int $mPower;

    #[Column(name: "out_gsm", type: "smallint")]
    private int $outGsm;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint")]
    private int $aOperator;

    #[Column(name: "a_datetime", type: "datetime")]
    private DateTime $aDatetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): int
    {
        return $this->batchNo;
    }

    public function setBatchNo(int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getSequence(): string
    {
        return HtmlDecode($this->sequence);
    }

    public function setSequence(string $value): static
    {
        $this->sequence = RemoveXss($value);
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getProcessName(): ?string
    {
        return HtmlDecode($this->processName);
    }

    public function setProcessName(?string $value): static
    {
        $this->processName = RemoveXss($value);
        return $this;
    }

    public function getMaterial(): string
    {
        return HtmlDecode($this->material);
    }

    public function setMaterial(string $value): static
    {
        $this->material = RemoveXss($value);
        return $this;
    }

    public function getMaterialName(): ?string
    {
        return HtmlDecode($this->materialName);
    }

    public function setMaterialName(?string $value): static
    {
        $this->materialName = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setQuantity(string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getMPower(): int
    {
        return $this->mPower;
    }

    public function setMPower(int $value): static
    {
        $this->mPower = $value;
        return $this;
    }

    public function getOutGsm(): int
    {
        return $this->outGsm;
    }

    public function setOutGsm(int $value): static
    {
        $this->outGsm = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): int
    {
        return $this->aOperator;
    }

    public function setAOperator(int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }
}
