<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "production_plan" table
 */
#[Entity]
#[Table(name: "production_plan")]
class ProductionPlan extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "plan_type", type: "smallint", nullable: true)]
    private ?int $planType;

    #[Column(name: "plan_for", type: "integer", nullable: true)]
    private ?int $planFor;

    #[Column(name: "to_start_days_before", type: "integer", nullable: true)]
    private ?int $toStartDaysBefore;

    #[Column(name: "to_finish_in_days", type: "integer", nullable: true)]
    private ?int $toFinishInDays;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getPlanType(): ?int
    {
        return $this->planType;
    }

    public function setPlanType(?int $value): static
    {
        $this->planType = $value;
        return $this;
    }

    public function getPlanFor(): ?int
    {
        return $this->planFor;
    }

    public function setPlanFor(?int $value): static
    {
        $this->planFor = $value;
        return $this;
    }

    public function getToStartDaysBefore(): ?int
    {
        return $this->toStartDaysBefore;
    }

    public function setToStartDaysBefore(?int $value): static
    {
        $this->toStartDaysBefore = $value;
        return $this;
    }

    public function getToFinishInDays(): ?int
    {
        return $this->toFinishInDays;
    }

    public function setToFinishInDays(?int $value): static
    {
        $this->toFinishInDays = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
