<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "production_partner" table
 */
#[Entity]
#[Table(name: "production_partner")]
class ProductionPartner extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(type: "smallint", nullable: true)]
    private ?int $country;

    #[Column(type: "integer", nullable: true)]
    private ?int $region;

    #[Column(type: "bigint", nullable: true)]
    private ?string $city;

    #[Column(name: "city_name", type: "string", nullable: true)]
    private ?string $cityName;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    #[Column(name: "bank_name", type: "string", nullable: true)]
    private ?string $bankName;

    #[Column(name: "bank_account_no", type: "string", nullable: true)]
    private ?string $bankAccountNo;

    #[Column(name: "bank_code", type: "string", nullable: true)]
    private ?string $bankCode;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(type: "smallint")]
    private int $category;

    #[Column(name: "reports_to", type: "smallint")]
    private int $reportsTo;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "integer", nullable: true)]
    private ?int $performance;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "integer")]
    private int $type;

    #[Column(name: "tax_registration", type: "string", nullable: true)]
    private ?string $taxRegistration;

    #[Column(type: "string", nullable: true)]
    private ?string $cin;

    #[Column(type: "string", nullable: true)]
    private ?string $pan;

    #[Column(type: "string", nullable: true)]
    private ?string $tan;

    #[Column(type: "string", nullable: true)]
    private ?string $msme;

    #[Column(type: "string", nullable: true)]
    private ?string $incoterm;

    #[Column(name: "port_air", type: "smallint", nullable: true)]
    private ?int $portAir;

    #[Column(name: "port_sea", type: "smallint", nullable: true)]
    private ?int $portSea;

    #[Column(type: "string", nullable: true)]
    private ?string $iec;

    #[Column(type: "string", nullable: true)]
    private ?string $rex;

    #[Column(type: "string", nullable: true)]
    private ?string $rcmc;

    #[Column(name: "delivery_terms", type: "string", nullable: true)]
    private ?string $deliveryTerms;

    #[Column(name: "shipping_terms", type: "string", nullable: true)]
    private ?string $shippingTerms;

    #[Column(name: "payment_terms", type: "string", nullable: true)]
    private ?string $paymentTerms;

    #[Column(name: "export_type", type: "string", nullable: true)]
    private ?string $exportType;

    #[Column(name: "lead_time_ss", type: "string", nullable: true)]
    private ?string $leadTimeSs;

    #[Column(name: "lead_time_cs", type: "string", nullable: true)]
    private ?string $leadTimeCs;

    #[Column(type: "string", nullable: true)]
    private ?string $cha;

    #[Column(name: "cha_email", type: "string", nullable: true)]
    private ?string $chaEmail;

    #[Column(name: "cha_phone", type: "string", nullable: true)]
    private ?string $chaPhone;

    #[Column(type: "string", nullable: true)]
    private ?string $forwarder;

    #[Column(name: "forwarder_email", type: "string", nullable: true)]
    private ?string $forwarderEmail;

    #[Column(name: "forwarder_phone", type: "string", nullable: true)]
    private ?string $forwarderPhone;

    #[Column(type: "string", nullable: true)]
    private ?string $merchant;

    #[Column(name: "merchant_email", type: "string", nullable: true)]
    private ?string $merchantEmail;

    #[Column(name: "merchant_phone", type: "string", nullable: true)]
    private ?string $merchantPhone;

    #[Column(name: "shipping_incharge", type: "string", nullable: true)]
    private ?string $shippingIncharge;

    #[Column(name: "shipping_email", type: "string", nullable: true)]
    private ?string $shippingEmail;

    #[Column(name: "shipping_phone", type: "string", nullable: true)]
    private ?string $shippingPhone;

    #[Column(name: "account_incharge", type: "string", nullable: true)]
    private ?string $accountIncharge;

    #[Column(name: "accounts_email", type: "string", nullable: true)]
    private ?string $accountsEmail;

    #[Column(name: "accounts_phone", type: "string", nullable: true)]
    private ?string $accountsPhone;

    #[Column(name: "warehouse_incharge", type: "string", nullable: true)]
    private ?string $warehouseIncharge;

    #[Column(name: "warehouse_email", type: "string", nullable: true)]
    private ?string $warehouseEmail;

    #[Column(name: "warehouse_phone", type: "string", nullable: true)]
    private ?string $warehousePhone;

    #[Column(name: "production_incharge", type: "string", nullable: true)]
    private ?string $productionIncharge;

    #[Column(name: "production_email", type: "string", nullable: true)]
    private ?string $productionEmail;

    #[Column(name: "production_phone", type: "string", nullable: true)]
    private ?string $productionPhone;

    #[Column(name: "qc_incharge", type: "string", nullable: true)]
    private ?string $qcIncharge;

    #[Column(name: "qc_email", type: "string", nullable: true)]
    private ?string $qcEmail;

    #[Column(name: "qc_phone", type: "string", nullable: true)]
    private ?string $qcPhone;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $uid;

    #[Column(name: "r_text", type: "text", nullable: true)]
    private ?string $rText;

    public function __construct()
    {
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getName(): string
    {
        return HtmlDecode($this->name);
    }

    public function setName(string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getCountry(): ?int
    {
        return $this->country;
    }

    public function setCountry(?int $value): static
    {
        $this->country = $value;
        return $this;
    }

    public function getRegion(): ?int
    {
        return $this->region;
    }

    public function setRegion(?int $value): static
    {
        $this->region = $value;
        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $value): static
    {
        $this->city = $value;
        return $this;
    }

    public function getCityName(): ?string
    {
        return HtmlDecode($this->cityName);
    }

    public function setCityName(?string $value): static
    {
        $this->cityName = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getBankName(): ?string
    {
        return HtmlDecode($this->bankName);
    }

    public function setBankName(?string $value): static
    {
        $this->bankName = RemoveXss($value);
        return $this;
    }

    public function getBankAccountNo(): ?string
    {
        return HtmlDecode($this->bankAccountNo);
    }

    public function setBankAccountNo(?string $value): static
    {
        $this->bankAccountNo = RemoveXss($value);
        return $this;
    }

    public function getBankCode(): ?string
    {
        return HtmlDecode($this->bankCode);
    }

    public function setBankCode(?string $value): static
    {
        $this->bankCode = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getReportsTo(): int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getPerformance(): ?int
    {
        return $this->performance;
    }

    public function setPerformance(?int $value): static
    {
        $this->performance = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getTaxRegistration(): ?string
    {
        return HtmlDecode($this->taxRegistration);
    }

    public function setTaxRegistration(?string $value): static
    {
        $this->taxRegistration = RemoveXss($value);
        return $this;
    }

    public function getCin(): ?string
    {
        return HtmlDecode($this->cin);
    }

    public function setCin(?string $value): static
    {
        $this->cin = RemoveXss($value);
        return $this;
    }

    public function getPan(): ?string
    {
        return HtmlDecode($this->pan);
    }

    public function setPan(?string $value): static
    {
        $this->pan = RemoveXss($value);
        return $this;
    }

    public function getTan(): ?string
    {
        return HtmlDecode($this->tan);
    }

    public function setTan(?string $value): static
    {
        $this->tan = RemoveXss($value);
        return $this;
    }

    public function getMsme(): ?string
    {
        return HtmlDecode($this->msme);
    }

    public function setMsme(?string $value): static
    {
        $this->msme = RemoveXss($value);
        return $this;
    }

    public function getIncoterm(): ?string
    {
        return HtmlDecode($this->incoterm);
    }

    public function setIncoterm(?string $value): static
    {
        $this->incoterm = RemoveXss($value);
        return $this;
    }

    public function getPortAir(): ?int
    {
        return $this->portAir;
    }

    public function setPortAir(?int $value): static
    {
        $this->portAir = $value;
        return $this;
    }

    public function getPortSea(): ?int
    {
        return $this->portSea;
    }

    public function setPortSea(?int $value): static
    {
        $this->portSea = $value;
        return $this;
    }

    public function getIec(): ?string
    {
        return HtmlDecode($this->iec);
    }

    public function setIec(?string $value): static
    {
        $this->iec = RemoveXss($value);
        return $this;
    }

    public function getRex(): ?string
    {
        return HtmlDecode($this->rex);
    }

    public function setRex(?string $value): static
    {
        $this->rex = RemoveXss($value);
        return $this;
    }

    public function getRcmc(): ?string
    {
        return HtmlDecode($this->rcmc);
    }

    public function setRcmc(?string $value): static
    {
        $this->rcmc = RemoveXss($value);
        return $this;
    }

    public function getDeliveryTerms(): ?string
    {
        return HtmlDecode($this->deliveryTerms);
    }

    public function setDeliveryTerms(?string $value): static
    {
        $this->deliveryTerms = RemoveXss($value);
        return $this;
    }

    public function getShippingTerms(): ?string
    {
        return HtmlDecode($this->shippingTerms);
    }

    public function setShippingTerms(?string $value): static
    {
        $this->shippingTerms = RemoveXss($value);
        return $this;
    }

    public function getPaymentTerms(): ?string
    {
        return HtmlDecode($this->paymentTerms);
    }

    public function setPaymentTerms(?string $value): static
    {
        $this->paymentTerms = RemoveXss($value);
        return $this;
    }

    public function getExportType(): ?string
    {
        return HtmlDecode($this->exportType);
    }

    public function setExportType(?string $value): static
    {
        $this->exportType = RemoveXss($value);
        return $this;
    }

    public function getLeadTimeSs(): ?string
    {
        return HtmlDecode($this->leadTimeSs);
    }

    public function setLeadTimeSs(?string $value): static
    {
        $this->leadTimeSs = RemoveXss($value);
        return $this;
    }

    public function getLeadTimeCs(): ?string
    {
        return HtmlDecode($this->leadTimeCs);
    }

    public function setLeadTimeCs(?string $value): static
    {
        $this->leadTimeCs = RemoveXss($value);
        return $this;
    }

    public function getCha(): ?string
    {
        return HtmlDecode($this->cha);
    }

    public function setCha(?string $value): static
    {
        $this->cha = RemoveXss($value);
        return $this;
    }

    public function getChaEmail(): ?string
    {
        return HtmlDecode($this->chaEmail);
    }

    public function setChaEmail(?string $value): static
    {
        $this->chaEmail = RemoveXss($value);
        return $this;
    }

    public function getChaPhone(): ?string
    {
        return HtmlDecode($this->chaPhone);
    }

    public function setChaPhone(?string $value): static
    {
        $this->chaPhone = RemoveXss($value);
        return $this;
    }

    public function getForwarder(): ?string
    {
        return HtmlDecode($this->forwarder);
    }

    public function setForwarder(?string $value): static
    {
        $this->forwarder = RemoveXss($value);
        return $this;
    }

    public function getForwarderEmail(): ?string
    {
        return HtmlDecode($this->forwarderEmail);
    }

    public function setForwarderEmail(?string $value): static
    {
        $this->forwarderEmail = RemoveXss($value);
        return $this;
    }

    public function getForwarderPhone(): ?string
    {
        return HtmlDecode($this->forwarderPhone);
    }

    public function setForwarderPhone(?string $value): static
    {
        $this->forwarderPhone = RemoveXss($value);
        return $this;
    }

    public function getMerchant(): ?string
    {
        return HtmlDecode($this->merchant);
    }

    public function setMerchant(?string $value): static
    {
        $this->merchant = RemoveXss($value);
        return $this;
    }

    public function getMerchantEmail(): ?string
    {
        return HtmlDecode($this->merchantEmail);
    }

    public function setMerchantEmail(?string $value): static
    {
        $this->merchantEmail = RemoveXss($value);
        return $this;
    }

    public function getMerchantPhone(): ?string
    {
        return HtmlDecode($this->merchantPhone);
    }

    public function setMerchantPhone(?string $value): static
    {
        $this->merchantPhone = RemoveXss($value);
        return $this;
    }

    public function getShippingIncharge(): ?string
    {
        return HtmlDecode($this->shippingIncharge);
    }

    public function setShippingIncharge(?string $value): static
    {
        $this->shippingIncharge = RemoveXss($value);
        return $this;
    }

    public function getShippingEmail(): ?string
    {
        return HtmlDecode($this->shippingEmail);
    }

    public function setShippingEmail(?string $value): static
    {
        $this->shippingEmail = RemoveXss($value);
        return $this;
    }

    public function getShippingPhone(): ?string
    {
        return HtmlDecode($this->shippingPhone);
    }

    public function setShippingPhone(?string $value): static
    {
        $this->shippingPhone = RemoveXss($value);
        return $this;
    }

    public function getAccountIncharge(): ?string
    {
        return HtmlDecode($this->accountIncharge);
    }

    public function setAccountIncharge(?string $value): static
    {
        $this->accountIncharge = RemoveXss($value);
        return $this;
    }

    public function getAccountsEmail(): ?string
    {
        return HtmlDecode($this->accountsEmail);
    }

    public function setAccountsEmail(?string $value): static
    {
        $this->accountsEmail = RemoveXss($value);
        return $this;
    }

    public function getAccountsPhone(): ?string
    {
        return HtmlDecode($this->accountsPhone);
    }

    public function setAccountsPhone(?string $value): static
    {
        $this->accountsPhone = RemoveXss($value);
        return $this;
    }

    public function getWarehouseIncharge(): ?string
    {
        return HtmlDecode($this->warehouseIncharge);
    }

    public function setWarehouseIncharge(?string $value): static
    {
        $this->warehouseIncharge = RemoveXss($value);
        return $this;
    }

    public function getWarehouseEmail(): ?string
    {
        return HtmlDecode($this->warehouseEmail);
    }

    public function setWarehouseEmail(?string $value): static
    {
        $this->warehouseEmail = RemoveXss($value);
        return $this;
    }

    public function getWarehousePhone(): ?string
    {
        return HtmlDecode($this->warehousePhone);
    }

    public function setWarehousePhone(?string $value): static
    {
        $this->warehousePhone = RemoveXss($value);
        return $this;
    }

    public function getProductionIncharge(): ?string
    {
        return HtmlDecode($this->productionIncharge);
    }

    public function setProductionIncharge(?string $value): static
    {
        $this->productionIncharge = RemoveXss($value);
        return $this;
    }

    public function getProductionEmail(): ?string
    {
        return HtmlDecode($this->productionEmail);
    }

    public function setProductionEmail(?string $value): static
    {
        $this->productionEmail = RemoveXss($value);
        return $this;
    }

    public function getProductionPhone(): ?string
    {
        return HtmlDecode($this->productionPhone);
    }

    public function setProductionPhone(?string $value): static
    {
        $this->productionPhone = RemoveXss($value);
        return $this;
    }

    public function getQcIncharge(): ?string
    {
        return HtmlDecode($this->qcIncharge);
    }

    public function setQcIncharge(?string $value): static
    {
        $this->qcIncharge = RemoveXss($value);
        return $this;
    }

    public function getQcEmail(): ?string
    {
        return HtmlDecode($this->qcEmail);
    }

    public function setQcEmail(?string $value): static
    {
        $this->qcEmail = RemoveXss($value);
        return $this;
    }

    public function getQcPhone(): ?string
    {
        return HtmlDecode($this->qcPhone);
    }

    public function setQcPhone(?string $value): static
    {
        $this->qcPhone = RemoveXss($value);
        return $this;
    }

    public function getUid(): ?string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(?string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }
}
