<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "production_employee_view_pw" table
 */
#[Entity]
#[Table(name: "production_employee_view_pw")]
class ProductionEmployeeViewPw extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $grp;

    #[Column(type: "integer", nullable: true)]
    #[GeneratedValue]
    private ?int $site;

    #[Column(name: "user_name", type: "string", nullable: true)]
    private ?string $userName;

    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $process;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSite(): ?int
    {
        return $this->site;
    }

    public function setSite(?int $value): static
    {
        $this->site = $value;
        return $this;
    }

    public function getUserName(): ?string
    {
        return HtmlDecode($this->userName);
    }

    public function setUserName(?string $value): static
    {
        $this->userName = RemoveXss($value);
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }
}
